/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.managers;

import com.nsr.ai.plugin.NSRAIPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class PlayerApiKeyManager {
    private final NSRAIPlugin plugin;
    private final Map<UUID, List<String>> playerApiKeys = new HashMap<UUID, List<String>>();
    private final Map<UUID, Integer> lastUsedKeyIndex = new HashMap<UUID, Integer>();

    public PlayerApiKeyManager(NSRAIPlugin plugin) {
        this.plugin = plugin;
    }

    public void addApiKey(UUID playerUuid, String apiKey) {
        this.playerApiKeys.computeIfAbsent(playerUuid, k -> new ArrayList()).add(apiKey);
    }

    public List<String> getApiKeys(UUID playerUuid) {
        return this.playerApiKeys.get(playerUuid);
    }

    public void clearApiKeys(UUID playerUuid) {
        this.playerApiKeys.remove(playerUuid);
    }

    public String getNextApiKey(UUID playerUuid) {
        List<String> keys2 = this.getApiKeys(playerUuid);
        if (keys2 == null || keys2.isEmpty()) {
            return null;
        }
        int lastIndex = this.lastUsedKeyIndex.getOrDefault(playerUuid, -1);
        int nextIndex = (lastIndex + 1) % keys2.size();
        this.lastUsedKeyIndex.put(playerUuid, nextIndex);
        return keys2.get(nextIndex);
    }

    public boolean hasApiKeys(UUID playerUuid) {
        return this.playerApiKeys.containsKey(playerUuid) && !this.playerApiKeys.get(playerUuid).isEmpty();
    }
}

