/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.managers;

import com.nsr.ai.plugin.NSRAIPlugin;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PrivacyManager {
    private final NSRAIPlugin plugin;
    private File privacyFile;
    private FileConfiguration privacyConfig;

    public PrivacyManager(NSRAIPlugin plugin) {
        this.plugin = plugin;
        this.privacyFile = new File(plugin.getDataFolder(), "privacy.yml");
        if (!this.privacyFile.exists()) {
            try {
                this.privacyFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.privacyConfig = YamlConfiguration.loadConfiguration((File)this.privacyFile);
    }

    public boolean canSaveChat(Player player) {
        return this.privacyConfig.getBoolean(String.valueOf(player.getUniqueId()) + ".chat", true);
    }

    public void setCanSaveChat(Player player, boolean canSave) {
        this.privacyConfig.set(String.valueOf(player.getUniqueId()) + ".chat", (Object)canSave);
        this.saveConfig();
    }

    public boolean canSaveMemory(Player player) {
        return this.privacyConfig.getBoolean(String.valueOf(player.getUniqueId()) + ".memory", true);
    }

    public void setCanSaveMemory(Player player, boolean canSave) {
        this.privacyConfig.set(String.valueOf(player.getUniqueId()) + ".memory", (Object)canSave);
        this.saveConfig();
    }

    public boolean canLogKnowledge(Player player) {
        return this.privacyConfig.getBoolean(String.valueOf(player.getUniqueId()) + ".knowledge", true);
    }

    public void setCanLogKnowledge(Player player, boolean canLog) {
        this.privacyConfig.set(String.valueOf(player.getUniqueId()) + ".knowledge", (Object)canLog);
        this.saveConfig();
    }

    private void saveConfig() {
        try {
            this.privacyConfig.save(this.privacyFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

