/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.pet;

import com.nsr.ai.plugin.NSRAIPlugin;
import com.nsr.ai.plugin.pet.Pet;
import com.nsr.ai.plugin.pet.PetManager;
import com.nsr.ai.plugin.pet.PetSpecies;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PetListener
implements Listener {
    private final NSRAIPlugin plugin;
    private final PetManager petManager;

    public PetListener(NSRAIPlugin plugin, PetManager petManager) {
        this.plugin = plugin;
        this.petManager = petManager;
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        String petDisplayName;
        Player player = event.getPlayer();
        String message = event.getMessage();
        ArrayList<MentionedPet> mentionedPets = new ArrayList<MentionedPet>();
        for (Map<String, Pet> playerPets : this.petManager.getLoadedPets().values()) {
            for (Pet pet : playerPets.values()) {
                String petName = pet.getPetName();
                String nickname = pet.getNickname();
                Pattern pattern = Pattern.compile("\\b(" + Pattern.quote(petName) + (String)(nickname != null ? "|" + Pattern.quote(nickname) : "") + ")\\b", 2);
                Matcher matcher = pattern.matcher(message);
                if (!matcher.find()) continue;
                mentionedPets.add(new MentionedPet(pet, matcher.start()));
            }
        }
        if (mentionedPets.isEmpty()) {
            return;
        }
        mentionedPets.sort(Comparator.comparingInt(MentionedPet::getIndex));
        Pet firstMentionedPet = ((MentionedPet)mentionedPets.get(0)).getPet();
        if (firstMentionedPet.getStatus().equalsIgnoreCase("dead")) {
            if (firstMentionedPet.getOwnerUuid().equals(player.getUniqueId())) {
                if (!firstMentionedPet.hasDeathMessageBeenSent()) {
                    petDisplayName = firstMentionedPet.getNickname() != null ? firstMentionedPet.getNickname() : firstMentionedPet.getPetName();
                    String deathMessage = this.plugin.colorize("&b<" + petDisplayName + ">: &fHey my friend, I am no more now because of " + firstMentionedPet.getDeathReason() + ". Last time I was on " + firstMentionedPet.getWorld() + ", X: " + String.format("%.1f", firstMentionedPet.getX()) + ", Y: " + String.format("%.1f", firstMentionedPet.getY()) + ", Z: " + String.format("%.1f", firstMentionedPet.getZ()) + ". See you in next gen. Love you my friend, you are my world, I lost my world. \ud83d\ude2d");
                    player.sendMessage(deathMessage);
                    firstMentionedPet.setDeathMessageSent(true);
                    if (firstMentionedPet.getNickname() != null && !firstMentionedPet.getNickname().isEmpty()) {
                        this.plugin.getReservedNicknameManager().releaseNickname(firstMentionedPet.getNickname());
                    }
                    this.plugin.getReservedNicknameManager().releaseNickname(firstMentionedPet.getPetName());
                    this.petManager.removePetFromMemory(firstMentionedPet.getOwnerUuid(), firstMentionedPet.getPetName());
                    this.petManager.savePet(firstMentionedPet);
                }
                event.setCancelled(false);
            } else {
                event.setCancelled(false);
            }
            return;
        }
        if (!firstMentionedPet.getOwnerUuid().equals(player.getUniqueId())) {
            event.setCancelled(true);
            petDisplayName = firstMentionedPet.getNickname() != null ? firstMentionedPet.getNickname() : firstMentionedPet.getPetName();
            player.sendMessage(this.plugin.colorize("&b<" + petDisplayName + ">: &f" + PetSpecies.fromEntityType(firstMentionedPet.getType()).getSound() + "..."));
            return;
        }
        if (firstMentionedPet.getNickname() == null || firstMentionedPet.getNickname().isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Your pet, " + firstMentionedPet.getPetName() + ", needs a nickname before you can talk to it. Use /ai pet nickname <nickname>");
            return;
        }
        event.setCancelled(true);
        String formattedPlayerMessage = this.plugin.colorize("&7<" + player.getName() + ">: " + message);
        player.sendMessage(formattedPlayerMessage);
        this.petManager.getPetDataStorage().logChatMessage(player.getName(), firstMentionedPet.getPetName(), player.getName(), message);
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            String response = this.generatePetResponse(firstMentionedPet, player, message);
            String petDisplayName = firstMentionedPet.getNickname() != null ? firstMentionedPet.getNickname() : firstMentionedPet.getPetName();
            PetSpecies species = PetSpecies.fromEntityType(firstMentionedPet.getType());
            String sound = species != null ? species.getSound() : "";
            String formattedPetMessage = this.plugin.colorize("&b<" + petDisplayName + ">: &f" + sound + " " + response);
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(formattedPetMessage));
            this.petManager.getPetDataStorage().logChatMessage(player.getName(), firstMentionedPet.getPetName(), petDisplayName, sound + " " + response);
            firstMentionedPet.setLastMessage(sound + " " + response);
            this.petManager.savePet(firstMentionedPet);
        });
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        Pet pet;
        Player owner;
        Tameable petEntity;
        if (event.getEntity() instanceof Tameable && (petEntity = (Tameable)event.getEntity()).isTamed() && petEntity.getOwner() != null && (owner = (Player)petEntity.getOwner()) != null && (pet = this.petManager.getPet(owner, petEntity.getCustomName())) != null && !pet.hasDeathMessageBeenSent()) {
            String deathReason = "unknown causes";
            if (event.getEntity().getLastDamageCause() != null) {
                deathReason = event.getEntity().getLastDamageCause().getCause().name().toLowerCase().replace("_", " ");
            }
            String lastLocation = "unknown location";
            if (petEntity.getLocation() != null) {
                lastLocation = String.format("World: %s, X: %.1f, Y: %.1f, Z: %.1f", petEntity.getLocation().getWorld().getName(), petEntity.getLocation().getX(), petEntity.getLocation().getY(), petEntity.getLocation().getZ());
                pet.setWorld(petEntity.getLocation().getWorld().getName());
                pet.setX(petEntity.getLocation().getX());
                pet.setY(petEntity.getLocation().getY());
                pet.setZ(petEntity.getLocation().getZ());
            }
            pet.setStatus("dead");
            pet.setDeathReason(deathReason);
            pet.setDeathMessageSent(true);
            String petDisplayName = pet.getNickname() != null ? pet.getNickname() : pet.getPetName();
            String deathMessage = this.plugin.colorize("&b<" + petDisplayName + ">: &fHey my friend, I am no more now because of " + deathReason + ". Last time I was on " + lastLocation + ". See you in next gen. \ud83d\udc3e");
            owner.sendMessage(deathMessage);
            if (pet.getNickname() != null && !pet.getNickname().isEmpty()) {
                this.plugin.getReservedNicknameManager().releaseNickname(pet.getNickname());
            }
            this.plugin.getReservedNicknameManager().releaseNickname(pet.getPetName());
            this.petManager.getPetDataStorage().logPetDeath(pet.getPetName(), owner.getName(), deathReason, lastLocation);
            String oldPetName = pet.getPetName();
            String newDeadPetName = this.petManager.getPetDataStorage().getUniqueDeadPetFolderName(owner.getName(), oldPetName);
            pet.setPetName(newDeadPetName);
            this.petManager.savePet(pet);
            this.petManager.getPetDataStorage().deletePetDataFolder(owner.getName(), oldPetName);
            this.petManager.removePetFromMemory(owner.getUniqueId(), oldPetName);
        }
    }

    @EventHandler
    public void onPetDamaged(EntityDamageByEntityEvent event) {
        if (event.getEntity() instanceof Tameable && event.getDamager() instanceof Player) {
            Pet pet;
            Tameable petEntity = (Tameable)event.getEntity();
            Player player = (Player)event.getDamager();
            if (petEntity.isTamed() && petEntity.getOwner() != null && petEntity.getOwner().getUniqueId().equals(player.getUniqueId()) && (pet = this.petManager.getPet(player, petEntity.getCustomName())) != null) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - pet.getLastHitTimestamp() > 60000L) {
                    pet.setRecentHits(0);
                }
                pet.setRecentHits(pet.getRecentHits() + 1);
                pet.setLastHitTimestamp(currentTime);
                if (pet.getRecentHits() <= 2) {
                    pet.setMood("sad");
                    pet.setBond(Math.max(0, pet.getBond() - 5));
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Your pet looks sad because you hurt it.");
                } else if (pet.getRecentHits() <= 4) {
                    pet.setMood("angry");
                    pet.setBond(Math.max(0, pet.getBond() - 10));
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Your pet is getting angry!");
                } else {
                    pet.setMood("furious");
                    pet.setBond(Math.max(0, pet.getBond() - 15));
                    player.sendMessage(String.valueOf(ChatColor.DARK_RED) + "Your pet is furious! You should probably stop.");
                }
                this.petManager.savePet(pet);
            }
        }
    }

    @EventHandler
    public void onPlayerInteractWithPet(PlayerInteractEntityEvent event) {
        if (event.getRightClicked() instanceof Tameable) {
            ItemStack itemInHand;
            Pet pet;
            Player player = event.getPlayer();
            Tameable petEntity = (Tameable)event.getRightClicked();
            if (petEntity.isTamed() && petEntity.getOwner() != null && petEntity.getOwner().getUniqueId().equals(player.getUniqueId()) && (pet = this.petManager.getPet(player, petEntity.getCustomName())) != null && this.isFoodItem((itemInHand = player.getInventory().getItemInMainHand()).getType())) {
                pet.setBond(Math.min(100, pet.getBond() + 2));
                pet.setHunger(Math.min(100, pet.getHunger() + 10));
                pet.setMood("happy");
                this.petManager.savePet(pet);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your pet looks happy because you fed it!");
            }
        }
    }

    @EventHandler
    public void onPetHealthLow(EntityDamageEvent event) {
        Tameable livingEntity;
        Pet pet;
        Player owner;
        Tameable petEntity;
        if (event.getEntity() instanceof Tameable && (petEntity = (Tameable)event.getEntity()).isTamed() && petEntity.getOwner() != null && (owner = (Player)petEntity.getOwner()) != null && (pet = this.petManager.getPet(owner, petEntity.getCustomName())) != null && (livingEntity = petEntity).getHealth() - event.getFinalDamage() <= 4.0) {
            String petDisplayName = pet.getNickname() != null ? pet.getNickname() : pet.getPetName();
            owner.sendMessage(this.plugin.colorize("&b<" + petDisplayName + ">: &fHey my friend\u2026 it might be time to say goodbye \ud83d\udc94 Maybe in another life we\u2019ll meet again. Love you \ud83d\udc3e"));
        }
    }

    @EventHandler
    public void onTame(EntityTameEvent event) {
        if (event.getEntity() instanceof Tameable) {
            Tameable petEntity = (Tameable)event.getEntity();
            if (event.getOwner() instanceof Player) {
                Pet pet;
                Player owner = (Player)event.getOwner();
                if (petEntity.getCustomName() != null && !petEntity.getCustomName().isEmpty() && (pet = this.petManager.getPet(owner, petEntity.getCustomName())) != null) {
                    pet.setTamedDate(new Date());
                    this.petManager.savePet(pet);
                    owner.sendMessage(String.valueOf(ChatColor.GREEN) + "Your pet \"" + petEntity.getCustomName() + "\" was tamed on " + new SimpleDateFormat("dd MMMM yyyy").format(pet.getTamedDate()));
                }
            }
        }
    }

    private boolean isFoodItem(Material material) {
        return material.isEdible();
    }

    private String generatePetResponse(Pet pet, Player player, String message) {
        String lowerCaseMessage = message.toLowerCase();
        if (lowerCaseMessage.contains("mood") || lowerCaseMessage.contains("how are you feeling")) {
            String mood = pet.getMood();
            String emoji = PetSpecies.fromEntityType(pet.getType()).getEmoji(mood);
            return "I'm feeling " + mood + " right now. " + emoji;
        }
        if (lowerCaseMessage.contains("when were you tamed")) {
            if (pet.getTamedDate() != null) {
                return "I was tamed on " + new SimpleDateFormat("dd MMMM yyyy").format(pet.getTamedDate()) + " \ud83d\udc15";
            }
            return "I don't remember exactly when I was tamed, but I'm happy to be with you!";
        }
        if (lowerCaseMessage.contains("when were you linked")) {
            if (pet.getLinkedDate() != null) {
                return "I was linked on " + new SimpleDateFormat("dd MMMM yyyy").format(pet.getLinkedDate()) + " \ud83d\udc3e";
            }
            return "I don't remember exactly when I was linked, but I'm happy to be with you!";
        }
        try {
            return this.plugin.getPetAIResponse(pet, player, message);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error generating pet AI response: " + e.getMessage());
            return "Woof! \ud83d\udc3e";
        }
    }

    private static class MentionedPet {
        private final Pet pet;
        private final int index;

        public MentionedPet(Pet pet, int index) {
            this.pet = pet;
            this.index = index;
        }

        public Pet getPet() {
            return this.pet;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

