/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.pet;

import com.nsr.ai.plugin.NSRAIPlugin;
import com.nsr.ai.plugin.pet.Pet;
import com.nsr.ai.plugin.pet.ReservedNicknameManager;
import com.nsr.ai.plugin.pet.data.PetDataStorage;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class PetManager {
    private final NSRAIPlugin plugin;
    private final PetDataStorage petDataStorage;
    private final Map<UUID, Map<String, Pet>> loadedPets = new HashMap<UUID, Map<String, Pet>>();
    private final ReservedNicknameManager reservedNicknameManager;

    public PetManager(NSRAIPlugin plugin) {
        this.plugin = plugin;
        this.petDataStorage = new PetDataStorage(plugin);
        this.reservedNicknameManager = plugin.getReservedNicknameManager();
    }

    public Map<UUID, Map<String, Pet>> getLoadedPets() {
        return this.loadedPets;
    }

    public void loadPetsForPlayer(Player player) {
        File playerPetFolder = new File(this.plugin.getDataFolder(), "pets" + File.separator + player.getName());
        if (!playerPetFolder.exists()) {
            return;
        }
        HashMap<String, Pet> playerPets = new HashMap<String, Pet>();
        for (File petFolder : playerPetFolder.listFiles()) {
            Pet pet;
            if (!petFolder.isDirectory() || (pet = this.petDataStorage.loadPet(player.getName(), petFolder.getName())) == null) continue;
            playerPets.put(pet.getPetName(), pet);
        }
        this.loadedPets.put(player.getUniqueId(), playerPets);
    }

    public void unloadPetsForPlayer(Player player) {
        this.loadedPets.remove(player.getUniqueId());
    }

    public Pet getPet(Player owner, String petName) {
        Map<String, Pet> playerPets = this.loadedPets.get(owner.getUniqueId());
        if (playerPets != null) {
            return playerPets.get(petName);
        }
        return null;
    }

    public void linkPet(Pet pet) {
        Map playerPets = this.loadedPets.computeIfAbsent(pet.getOwnerUuid(), k -> new HashMap());
        playerPets.put(pet.getPetName(), pet);
        this.plugin.getReservedNicknameManager().reserveNickname(pet.getPetName(), pet.getOwnerUuid());
        this.petDataStorage.savePet(pet);
    }

    public void savePet(Pet pet) {
        this.petDataStorage.savePet(pet);
    }

    public void loadAllPets() {
        File petsFolder = new File(this.plugin.getDataFolder(), "pets");
        if (!petsFolder.exists()) {
            return;
        }
        for (File playerFolder : petsFolder.listFiles()) {
            if (!playerFolder.isDirectory()) continue;
            String ownerName = playerFolder.getName();
            for (File petFolder : playerFolder.listFiles()) {
                Pet pet;
                if (!petFolder.isDirectory() || (pet = this.petDataStorage.loadPet(ownerName, petFolder.getName())) == null || pet.getStatus().equalsIgnoreCase("dead")) continue;
                this.loadedPets.computeIfAbsent(pet.getOwnerUuid(), k -> new HashMap()).put(pet.getPetName(), pet);
            }
        }
        this.plugin.getLogger().info("Loaded " + this.loadedPets.size() + " pets from disk.");
    }

    public PetDataStorage getPetDataStorage() {
        return this.petDataStorage;
    }

    public void removePetFromMemory(UUID ownerUuid, String petName) {
        Map<String, Pet> playerPets = this.loadedPets.get(ownerUuid);
        if (playerPets != null) {
            playerPets.remove(petName);
            if (playerPets.isEmpty()) {
                this.loadedPets.remove(ownerUuid);
            }
        }
    }
}

