/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.pet.data;

import com.nsr.ai.plugin.NSRAIPlugin;
import com.nsr.ai.plugin.pet.Pet;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;

public class PetDataStorage {
    private final NSRAIPlugin plugin;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public PetDataStorage(NSRAIPlugin plugin) {
        this.plugin = plugin;
    }

    public void savePet(Pet pet) {
        File petFile = this.getPetDataFile(pet.getOwnerName(), pet.getPetName());
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)petFile);
        config.set("pet-name", (Object)pet.getPetName());
        config.set("nickname", (Object)pet.getNickname());
        config.set("type", (Object)pet.getType().name());
        config.set("owner", (Object)pet.getOwnerName());
        config.set("owner-uuid", (Object)pet.getOwnerUuid().toString());
        config.set("personality", (Object)pet.getPersonality());
        config.set("bond", (Object)pet.getBond());
        config.set("hunger", (Object)pet.getHunger());
        config.set("mood", (Object)pet.getMood());
        if (pet.getTamedDate() != null) {
            config.set("tamed-date", (Object)this.dateFormat.format(pet.getTamedDate()));
        }
        if (pet.getLinkedDate() != null) {
            config.set("linked-date", (Object)this.dateFormat.format(pet.getLinkedDate()));
        }
        config.set("last-message", (Object)pet.getLastMessage());
        config.set("status", (Object)pet.getStatus());
        config.set("recent-hits", (Object)pet.getRecentHits());
        config.set("last-hit-timestamp", (Object)pet.getLastHitTimestamp());
        config.set("death-message-sent", (Object)pet.hasDeathMessageBeenSent());
        config.set("death-reason", (Object)pet.getDeathReason());
        config.set("location.world", (Object)pet.getWorld());
        config.set("location.x", (Object)pet.getX());
        config.set("location.y", (Object)pet.getY());
        config.set("location.z", (Object)pet.getZ());
        try {
            config.save(petFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save pet data for " + pet.getPetName());
            e.printStackTrace();
        }
    }

    public Pet loadPet(String ownerName, String petName) {
        File petFile = this.getPetDataFile(ownerName, petName);
        if (!petFile.exists()) {
            return null;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)petFile);
        try {
            String name = config.getString("pet-name");
            EntityType type = EntityType.valueOf((String)config.getString("type"));
            UUID ownerUuid = UUID.fromString(config.getString("owner-uuid"));
            Pet pet = new Pet(name, type, ownerName, ownerUuid);
            pet.setNickname(config.getString("nickname"));
            pet.setPersonality(config.getString("personality"));
            pet.setBond(config.getInt("bond"));
            pet.setHunger(config.getInt("hunger"));
            pet.setMood(config.getString("mood"));
            pet.setLastMessage(config.getString("last-message"));
            if (config.getString("tamed-date") != null) {
                pet.setTamedDate(this.dateFormat.parse(config.getString("tamed-date")));
            }
            if (config.getString("linked-date") != null) {
                pet.setLinkedDate(this.dateFormat.parse(config.getString("linked-date")));
            }
            pet.setStatus(config.getString("status", "alive"));
            pet.setRecentHits(config.getInt("recent-hits", 0));
            pet.setLastHitTimestamp(config.getLong("last-hit-timestamp", 0L));
            pet.setDeathMessageSent(config.getBoolean("death-message-sent", false));
            pet.setDeathReason(config.getString("death-reason"));
            pet.setWorld(config.getString("location.world"));
            pet.setX(config.getDouble("location.x"));
            pet.setY(config.getDouble("location.y"));
            pet.setZ(config.getDouble("location.z"));
            return pet;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Could not load pet data for " + petName);
            e.printStackTrace();
            return null;
        }
    }

    public File getPetDataFile(String ownerName, String petName) {
        File playerPetFolder = new File(this.plugin.getDataFolder(), "pets" + File.separator + ownerName);
        if (!playerPetFolder.exists()) {
            playerPetFolder.mkdirs();
        }
        return new File(playerPetFolder, petName + File.separator + "data.yml");
    }

    public File getChatsFile(String ownerName, String petName) {
        File petFolder;
        File playerPetFolder = new File(this.plugin.getDataFolder(), "pets" + File.separator + ownerName);
        if (!playerPetFolder.exists()) {
            playerPetFolder.mkdirs();
        }
        if (!(petFolder = new File(playerPetFolder, petName)).exists()) {
            petFolder.mkdirs();
        }
        return new File(petFolder, "chats.yml");
    }

    public void logChatMessage(String ownerName, String petName, String sender, String message) {
        File chatsFile = this.getChatsFile(ownerName, petName);
        try {
            YamlConfiguration chats = YamlConfiguration.loadConfiguration((File)chatsFile);
            String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            chats.set(timestamp, (Object)(sender + ": " + message));
            chats.save(chatsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not log chat message for pet " + petName);
            e.printStackTrace();
        }
    }

    public void logPetDeath(String petName, String ownerName, String reason, String location) {
        File deathLogFile = new File(this.plugin.getDataFolder(), "death_log.yml");
        YamlConfiguration deathLogConfig = YamlConfiguration.loadConfiguration((File)deathLogFile);
        String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        String logEntry = String.format("[%s] Pet: %s, Owner: %s, Reason: %s, Location: %s", timestamp, petName, ownerName, reason, location);
        List logs = deathLogConfig.getStringList("deaths");
        logs.add(logEntry);
        deathLogConfig.set("deaths", (Object)logs);
        try {
            deathLogConfig.save(deathLogFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save pet death log: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void renamePetDataFolder(String ownerName, String petName) {
        File newPetFolder;
        File petFolder = new File(this.plugin.getDataFolder(), "pets" + File.separator + ownerName + File.separator + petName);
        if (!petFolder.exists()) {
            return;
        }
        Object newPetFolderName = petName;
        int counter = 0;
        do {
            newPetFolderName = petName + "_dead";
            if (counter > 0) {
                newPetFolderName = (String)newPetFolderName + "_" + counter;
            }
            newPetFolder = new File(this.plugin.getDataFolder(), "pets" + File.separator + ownerName + File.separator + (String)newPetFolderName);
            ++counter;
        } while (newPetFolder.exists());
        if (petFolder.renameTo(newPetFolder)) {
            this.plugin.getLogger().info("Renamed dead pet folder from " + petFolder.getName() + " to " + newPetFolder.getName());
        } else {
            this.plugin.getLogger().warning("Failed to rename dead pet folder: " + petFolder.getName());
        }
    }

    public String getUniqueDeadPetFolderName(String ownerName, String petName) {
        File newPetFolder;
        String baseName = petName + "_dead";
        int counter = 0;
        String uniqueName = baseName;
        do {
            if (counter > 0) {
                uniqueName = baseName + "_" + counter;
            }
            newPetFolder = new File(this.plugin.getDataFolder(), "pets" + File.separator + ownerName + File.separator + uniqueName);
            ++counter;
        } while (newPetFolder.exists());
        return uniqueName;
    }

    public void deletePetDataFolder(String ownerName, String petName) {
        File petFolder = new File(this.plugin.getDataFolder(), "pets" + File.separator + ownerName + File.separator + petName);
        if (petFolder.exists()) {
            try {
                this.deleteDirectory(petFolder);
                this.plugin.getLogger().info("Deleted old pet folder: " + petFolder.getName());
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to delete old pet folder: " + petFolder.getName() + " - " + e.getMessage());
            }
        }
    }

    private void deleteDirectory(File directory) throws IOException {
        File[] files;
        if (directory.isDirectory() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                this.deleteDirectory(file);
            }
        }
        if (!directory.delete()) {
            throw new IOException("Failed to delete file or directory: " + directory.getAbsolutePath());
        }
    }
}

