/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.util;

import com.nsr.ai.plugin.NSRAIPlugin;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ChatLogger {
    private final NSRAIPlugin plugin;
    private final ConcurrentLinkedQueue<LogEntry> logQueue = new ConcurrentLinkedQueue();
    private final File playerChatHistoryDir;
    private final File adminChatHistoryDir;

    public ChatLogger(NSRAIPlugin plugin) {
        this.plugin = plugin;
        this.playerChatHistoryDir = new File(plugin.getDataFolder(), "playerchathistory");
        this.adminChatHistoryDir = new File(plugin.getDataFolder(), "adminchathistory");
        if (!this.playerChatHistoryDir.exists()) {
            this.playerChatHistoryDir.mkdirs();
        }
        if (!this.adminChatHistoryDir.exists()) {
            this.adminChatHistoryDir.mkdirs();
        }
        this.startWriterTask();
    }

    public void log(Player player, String message, boolean isAdmin, boolean isAI) {
        String prefix = isAI ? "[AI] " : "[" + player.getName() + "] ";
        this.logQueue.offer(new LogEntry(player.getUniqueId().toString(), player.getName(), prefix + message, isAdmin));
    }

    private void startWriterTask() {
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            while (!this.logQueue.isEmpty()) {
                LogEntry entry = this.logQueue.poll();
                if (entry == null) continue;
                this.writeToFile(entry);
            }
        }, 100L, 100L);
    }

    private void writeToFile(LogEntry entry) {
        File logFile = this.getLogFile(entry.playerName, entry.playerUUID, entry.isAdmin);
        File playerDir = logFile.getParentFile();
        if (!playerDir.exists()) {
            playerDir.mkdirs();
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(logFile, true));){
            String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            writer.write("[" + timestamp + "] " + entry.message);
            writer.newLine();
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not write to chat log for " + entry.playerName, e);
        }
    }

    public File getLogFile(Player player, boolean isAdmin) {
        return this.getLogFile(player.getName(), player.getUniqueId().toString(), isAdmin);
    }

    private File getLogFile(String playerName, String playerUUID, boolean isAdmin) {
        File playerDir = isAdmin ? new File(this.adminChatHistoryDir, playerName + "-" + playerUUID) : new File(this.playerChatHistoryDir, playerName + "-" + playerUUID);
        return new File(playerDir, "chat.txt");
    }

    private static class LogEntry {
        final String playerUUID;
        final String playerName;
        final String message;
        final boolean isAdmin;

        LogEntry(String playerUUID, String playerName, String message, boolean isAdmin) {
            this.playerUUID = playerUUID;
            this.playerName = playerName;
            this.message = message;
            this.isAdmin = isAdmin;
        }
    }
}

