/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nsr.ai.plugin.NSRAIPlugin;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    private final NSRAIPlugin plugin;
    private final String currentVersion;
    private final String updateUrl;
    private String latestVersion;
    private List<String> latestFeatures;
    private boolean updateCheckComplete = false;
    private final Gson gson = new Gson();

    public UpdateChecker(NSRAIPlugin plugin, String updateUrl) {
        this.plugin = plugin;
        this.currentVersion = plugin.getDescription().getVersion();
        this.updateUrl = updateUrl;
    }

    public void checkForUpdates() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL(this.updateUrl).openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    String inputLine;
                    BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder content = new StringBuilder();
                    while ((inputLine = in.readLine()) != null) {
                        content.append(inputLine);
                    }
                    in.close();
                    connection.disconnect();
                    JsonObject jsonResponse = JsonParser.parseString(content.toString()).getAsJsonObject();
                    this.latestVersion = jsonResponse.get("latest_version").getAsString();
                    JsonArray featuresArray = jsonResponse.getAsJsonArray("features");
                    this.latestFeatures = new ArrayList<String>();
                    if (featuresArray != null) {
                        for (int i = 0; i < featuresArray.size(); ++i) {
                            this.latestFeatures.add(featuresArray.get(i).getAsString());
                        }
                    }
                } else {
                    this.plugin.getLogger().warning("UpdateChecker: Failed to fetch update. HTTP response code: " + responseCode);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "UpdateChecker: Could not check for updates: " + e.getMessage(), e);
            }
            finally {
                this.updateCheckComplete = true;
            }
        });
    }

    public boolean isUpdateCheckComplete() {
        return this.updateCheckComplete;
    }

    public boolean isOutdated() {
        if (this.latestVersion == null || this.latestVersion.isEmpty()) {
            return false;
        }
        return !this.currentVersion.equals(this.latestVersion);
    }

    private int compareVersions(String v1, String v2) {
        String preRelease2;
        String[] parts1 = v1.split("-")[0].split("\\.");
        String[] parts2 = v2.split("-")[0].split("\\.");
        int length = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < length; ++i) {
            int p2;
            int p1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int n = p2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
            if (p1 < p2) {
                return -1;
            }
            if (p1 <= p2) continue;
            return 1;
        }
        String preRelease1 = v1.contains("-") ? v1.split("-")[1] : "";
        String string = preRelease2 = v2.contains("-") ? v2.split("-")[1] : "";
        if (preRelease1.isEmpty() && !preRelease2.isEmpty()) {
            return 1;
        }
        if (!preRelease1.isEmpty() && preRelease2.isEmpty()) {
            return -1;
        }
        return preRelease1.compareTo(preRelease2);
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public List<String> getLatestFeatures() {
        return this.latestFeatures;
    }
}

