/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.security;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nsr.ai.plugin.addons.AddonManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SecurityManager {
    private static final String SECURITY_JAR_URL = "https://github.com/Minecraft2613/Secuirty/raw/main/security.jar";
    private static final String CLOUDFLARE_VERSION_URL = "https://nsr-ai-security.1987sakshamsingh.workers.dev/version";
    private static final String SECURITY_FOLDER_PATH = "security";
    private static final String SECURITY_FILE_NAME = "security.jar";
    private final JavaPlugin plugin;
    private AddonManager addonManager;
    private Object securityMainInstance;
    private Method initMethod;
    private Method validateAddonMethod;
    private Method getVersionMethod;
    private URLClassLoader currentClassLoader;
    private final Gson gson = new Gson();
    private final OkHttpClient httpClient = new OkHttpClient();

    public SecurityManager(JavaPlugin plugin, AddonManager addonManager) {
        this.plugin = plugin;
        this.addonManager = addonManager;
    }

    public boolean initialize() {
        File securityFolder = new File(this.plugin.getDataFolder(), SECURITY_FOLDER_PATH);
        if (!securityFolder.exists()) {
            securityFolder.mkdirs();
        }
        File securityJarFile = new File(securityFolder, SECURITY_FILE_NAME);
        String localVersion = null;
        if (securityJarFile.exists()) {
            localVersion = this.getJarVersion(securityJarFile);
        }
        try {
            RemoteSecurityInfo remoteInfo = this.getRemoteSecurityInfo();
            if (remoteInfo == null) {
                this.plugin.getLogger().warning("[NSR-AI] Could not fetch remote security info. Proceeding with local JAR if available.");
                if (!securityJarFile.exists()) {
                    this.plugin.getLogger().severe("[NSR-AI] No local security JAR and no remote info. Shutting down plugin.");
                    Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
                    return false;
                }
            } else if (!securityJarFile.exists() || localVersion == null || !localVersion.equals(remoteInfo.version)) {
                this.plugin.getLogger().info("[NSR-AI] Security JAR missing or outdated. Downloading/Updating...");
                this.performUpdateAndReload(securityJarFile, remoteInfo);
                this.addonManager.reloadAddons();
            }
            boolean loaded = this.loadSecurityJar(securityJarFile);
            Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::checkAndPerformUpdate, 4800L, 4800L);
            return loaded;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "[NSR-AI] Failed to initialize security system. Shutting down plugin.", e);
            Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
            return false;
        }
    }

    public boolean performUpdateAndReload(File securityJarFile, RemoteSecurityInfo remoteInfo) {
        this.plugin.getLogger().info("[NSR-AI] Attempting to update security JAR...");
        try {
            if (remoteInfo == null) {
                this.plugin.getLogger().warning("[NSR-AI] Remote security info is null. Update aborted.");
                return false;
            }
            this.plugin.getLogger().info("[NSR-AI] Downloading new security JAR (Version: " + remoteInfo.version + ") from NSR-AI update server...");
            this.downloadSecurityJar(securityJarFile, remoteInfo.downloadUrl);
            this.plugin.getLogger().info("[NSR-AI] Reloading security system...");
            boolean loaded = this.loadSecurityJar(securityJarFile);
            return loaded;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "[NSR-AI] Failed to update and reload security system.", e);
            return false;
        }
    }

    private void downloadSecurityJar(File targetFile, String downloadUrl) throws IOException {
        URL website = new URL(downloadUrl);
        try (ReadableByteChannel rbc = Channels.newChannel(website.openStream());
             FileOutputStream fos = new FileOutputStream(targetFile);){
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            this.plugin.getLogger().info("[NSR-AI] Security JAR downloaded successfully from NSR-AI update server.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RemoteSecurityInfo getRemoteSecurityInfo() {
        try {
            Request request = new Request.Builder().url(CLOUDFLARE_VERSION_URL).build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    this.plugin.getLogger().warning("[NSR-AI] Failed to fetch remote security info from NSR-AI update server: " + response.code() + " " + response.message());
                    RemoteSecurityInfo remoteSecurityInfo = null;
                    return remoteSecurityInfo;
                }
                String responseBody = response.body().string();
                JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
                String version = jsonResponse.get("version").getAsString();
                String downloadUrl = jsonResponse.get("download_url").getAsString();
                RemoteSecurityInfo remoteSecurityInfo = new RemoteSecurityInfo(version, downloadUrl);
                return remoteSecurityInfo;
            }
        }
        catch (IOException | IllegalStateException e) {
            this.plugin.getLogger().log(Level.WARNING, "[NSR-AI] Error fetching remote security info from NSR-AI update server", e);
            return null;
        }
    }

    public void checkAndPerformUpdate() {
        File securityFolder = new File(this.plugin.getDataFolder(), SECURITY_FOLDER_PATH);
        File securityJarFile = new File(securityFolder, SECURITY_FILE_NAME);
        try {
            RemoteSecurityInfo remoteInfo = this.getRemoteSecurityInfo();
            if (remoteInfo == null) {
                this.plugin.getLogger().warning("[NSR-AI] Could not fetch remote security info for periodic check.");
                return;
            }
            String localVersion = this.getSecurityVersion();
            if (localVersion == null || !localVersion.equals(remoteInfo.version)) {
                this.plugin.getLogger().info("[NSR-AI] Remote security JAR version is different. Initiating update.");
                this.performUpdateAndReload(securityJarFile, remoteInfo);
                this.addonManager.reloadAddons();
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "[NSR-AI] Error during periodic security update check.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getJarVersion(File jarFile) {
        try (JarFile jar = new JarFile(jarFile);){
            Manifest manifest = jar.getManifest();
            if (manifest == null) return null;
            Attributes attributes = manifest.getMainAttributes();
            String string = attributes.getValue("Security-Version");
            return string;
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "[NSR-AI] Could not read Security-Version from JAR: " + jarFile.getName(), e);
        }
        return null;
    }

    private boolean loadSecurityJar(File securityJarFile) throws Exception {
        if (!securityJarFile.exists()) {
            this.plugin.getLogger().severe("[NSR-AI] Security JAR file not found at: " + securityJarFile.getAbsolutePath());
            return false;
        }
        if (this.currentClassLoader != null) {
            try {
                this.currentClassLoader.close();
                this.plugin.getLogger().info("[NSR-AI] Closed previous Security JAR classloader.");
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.WARNING, "[NSR-AI] Failed to close previous Security JAR classloader.", e);
            }
        }
        URL jarUrl = securityJarFile.toURI().toURL();
        this.currentClassLoader = new URLClassLoader(new URL[]{jarUrl}, this.plugin.getClass().getClassLoader());
        Class<?> securityMainClass = this.currentClassLoader.loadClass("com.nsr.security.SecurityMain");
        this.securityMainInstance = securityMainClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.initMethod = securityMainClass.getMethod("init", new Class[0]);
        this.validateAddonMethod = securityMainClass.getMethod("validateAddon", String.class);
        this.getVersionMethod = securityMainClass.getMethod("getVersion", new Class[0]);
        this.initMethod.invoke(this.securityMainInstance, new Object[0]);
        this.plugin.getLogger().info("[NSR-AI] Security system loaded. Version: " + this.getSecurityVersion());
        return true;
    }

    public boolean validateAddon(String addonName) {
        if (this.validateAddonMethod == null) {
            this.plugin.getLogger().warning("[NSR-AI] Security system not initialized. Cannot validate addon: " + addonName);
            return false;
        }
        try {
            return (Boolean)this.validateAddonMethod.invoke(this.securityMainInstance, addonName);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "[NSR-AI] Error validating addon " + addonName, e);
            return false;
        }
    }

    public String getSecurityVersion() {
        if (this.getVersionMethod == null) {
            return "UNKNOWN";
        }
        try {
            return (String)this.getVersionMethod.invoke(this.securityMainInstance, new Object[0]);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "[NSR-AI] Error getting security version.", e);
            return "ERROR";
        }
    }

    public static class RemoteSecurityInfo {
        public String version;
        public String downloadUrl;

        RemoteSecurityInfo(String version, String downloadUrl) {
            this.version = version;
            this.downloadUrl = downloadUrl;
        }
    }
}

