/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class ConversationManager {
    private final Map<UUID, List<Message>> conversationHistory = new ConcurrentHashMap<UUID, List<Message>>();
    private final int maxHistoryLength;

    public ConversationManager(int maxHistoryLength) {
        this.maxHistoryLength = maxHistoryLength;
    }

    public void addMessage(UUID playerId, Message message) {
        this.conversationHistory.computeIfAbsent(playerId, k -> new ArrayList()).add(message);
        List<Message> history = this.conversationHistory.get(playerId);
        if (history.size() > this.maxHistoryLength) {
            history.remove(0);
        }
    }

    public List<Message> getHistory(UUID playerId) {
        return this.conversationHistory.getOrDefault(playerId, new ArrayList());
    }

    public void clearHistory(UUID playerId) {
        this.conversationHistory.remove(playerId);
    }

    public static class Message {
        private final String role;
        private final String content;

        public Message(String role, String content) {
            this.role = role;
            this.content = content;
        }

        public String getRole() {
            return this.role;
        }

        public String getContent() {
            return this.content;
        }
    }
}

