/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nsr.ai.plugin.ApiKeyManager;
import com.nsr.ai.plugin.ConversationManager;
import com.nsr.ai.plugin.PlayerListener;
import com.nsr.ai.plugin.addons.AddonManager;
import com.nsr.ai.plugin.api.NSRaiAPI;
import com.nsr.ai.plugin.command.CommandManager;
import com.nsr.ai.plugin.util.ChatHistoryManager;
import com.nsr.ai.plugin.util.ConfirmationManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.milkbowl.vault.economy.Economy;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class NSRAIPlugin
extends JavaPlugin
implements Listener,
NSRaiAPI {
    private ConfirmationManager confirmationManager;
    private String adminActivationCode;
    private String defaultGeminiModel;
    private String defaultClaudeModel;
    private String defaultOpenAIModel;
    private String defaultApiProvider;
    private List<String> apiKeys;
    private ApiKeyManager apiKeyManager;
    private String aiChatColor;
    private String userChatColor;
    private String aiPrefix;
    private String userPrefix;
    private String adminAiPrefix;
    private String aiNotConfiguredMessage;
    private String apiErrorMessage;
    private String permissionDeniedMessage;
    private String noValidKeysMessage;
    private String allKeysRateLimitedMessage;
    private String systemPrompt;
    private boolean codeBlockerEnabled;
    private String codeBlockerMessage;
    private ConversationManager conversationManager;
    private AddonManager addonManager;
    private ChatHistoryManager chatHistoryManager;
    private final Map<UUID, Boolean> adminModePlayers = new HashMap<UUID, Boolean>();
    private final Map<String, String> knowledgeBase = new HashMap<String, String>();
    private File knowledgeFile;
    private YamlConfiguration knowledgeConfig;
    private final OkHttpClient httpClient = new OkHttpClient.Builder().readTimeout(10L, TimeUnit.SECONDS).build();
    private final Gson gson = new Gson();

    public void onEnable() {
        this.saveDefaultConfig();
        FileConfiguration config = this.getConfig();
        this.updateConfig();
        this.reloadConfig();
        config = this.getConfig();
        this.loadConfig();
        this.chatHistoryManager = new ChatHistoryManager(this);
        this.confirmationManager = new ConfirmationManager(this);
        this.apiKeyManager = new ApiKeyManager(this.apiKeys);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> this.apiKeyManager.validateKeys(this.defaultGeminiModel, this.defaultClaudeModel, this.defaultOpenAIModel));
        this.conversationManager = new ConversationManager(config.getInt("conversation-history-length", 10));
        this.addonManager = new AddonManager(this);
        this.addonManager.loadAddons();
        this.knowledgeFile = new File(this.getDataFolder(), "knowledge.yml");
        if (!this.knowledgeFile.exists()) {
            try {
                this.knowledgeFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Could not create knowledge.yml", e);
            }
        }
        this.knowledgeConfig = YamlConfiguration.loadConfiguration((File)this.knowledgeFile);
        this.loadKnowledgeBase();
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.getCommand("ai").setExecutor((CommandExecutor)new CommandManager(this));
        this.getLogger().info("NSR-AI_lowered has been enabled!");
    }

    public void onDisable() {
        this.saveKnowledgeBase();
        if (this.addonManager != null) {
            this.addonManager.unloadAddons();
        }
        this.getLogger().info("NSR-AI_lowered has been disabled!");
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.adminActivationCode = config.getString("admin-activation-code", "3637");
        this.defaultGeminiModel = config.getString("default-gemini-model", "gemini-1.5-flash");
        this.defaultClaudeModel = config.getString("default-claude-model", "claude-3-opus-20240229");
        this.defaultOpenAIModel = config.getString("default-openai-model", "gpt-4");
        this.defaultApiProvider = config.getString("default-api-provider", "all");
        this.apiKeys = config.getStringList("api-keys");
        this.aiChatColor = config.getString("chat-colors.ai", "&b");
        this.userChatColor = config.getString("chat-colors.user", "&7");
        this.aiPrefix = this.colorize(config.getString("chat-prefixes.ai", "&b[AI]"));
        this.userPrefix = this.colorize(config.getString("chat-prefixes.user", "&7[You]"));
        this.adminAiPrefix = this.colorize(config.getString("chat-prefixes.admin-ai", "&c[AI]"));
        this.aiNotConfiguredMessage = this.colorize(config.getString("messages.ai-not-configured", "&cThe AI chat is not configured correctly. Please contact the server owner."));
        this.apiErrorMessage = this.colorize(config.getString("messages.api-error", "&cAPI Error: Could not get a response from the AI. Please try again later."));
        this.permissionDeniedMessage = this.colorize(config.getString("messages.permission-denied", "&cI don't have permission to fulfill that request for you."));
        this.noValidKeysMessage = this.colorize(config.getString("messages.no-valid-keys", "&cThere are no valid API keys available. Please contact the server owner."));
        this.allKeysRateLimitedMessage = this.colorize(config.getString("messages.all-keys-rate-limited", "&cAll API keys are currently rate-limited. Please try again later."));
        this.systemPrompt = config.getString("system-prompt", "You are a helpful AI.");
        this.codeBlockerEnabled = config.getBoolean("code-blocker.enabled", true);
        this.codeBlockerMessage = this.colorize(config.getString("code-blocker.message", "&cThis is a game built for fun and answering, not for coding."));
    }

    private void loadKnowledgeBase() {
        this.knowledgeBase.clear();
        for (String key : this.knowledgeConfig.getKeys(true)) {
            if (!this.knowledgeConfig.isString(key)) continue;
            this.knowledgeBase.put(key.toLowerCase(), this.knowledgeConfig.getString(key));
        }
        this.getLogger().info("Loaded " + this.knowledgeBase.size() + " entries into knowledge base.");
    }

    public void handleAIConversation(Player player, String message, boolean isAdmin, String provider, String mode) {
        String finalMessage = message;
        String lowerCaseMessage = finalMessage.toLowerCase();
        if (lowerCaseMessage.equals("hi") || lowerCaseMessage.equals("hey")) {
            player.sendMessage(this.colorize(this.aiPrefix + this.aiChatColor + "hey " + player.getName() + " how are you do you have question or anything else"));
            return;
        }
        if (this.codeBlockerEnabled && (lowerCaseMessage.contains("code") || lowerCaseMessage.contains("script") || lowerCaseMessage.contains("program"))) {
            player.sendMessage(this.codeBlockerMessage);
            return;
        }
        if (mode.equals("KNOWLEDGE_ONLY")) {
            ArrayList matchingResponses = new ArrayList();
            HashMap<String, Integer> responseScores = new HashMap<String, Integer>();
            int SCORE_THRESHOLD = 2;
            String[] queryWords = lowerCaseMessage.split("\\s+");
            for (Map.Entry<String, String> entry2 : this.knowledgeBase.entrySet()) {
                int score = 0;
                String entryKeyLower = entry2.getKey().toLowerCase();
                String entryValueLower = entry2.getValue().toLowerCase();
                for (String word : queryWords) {
                    if (!entryKeyLower.contains(word) && !entryValueLower.contains(word)) continue;
                    ++score;
                }
                if (score < 2) continue;
                if (responseScores.containsKey(entry2.getValue())) {
                    responseScores.put(entry2.getValue(), Math.max((Integer)responseScores.get(entry2.getValue()), score));
                    continue;
                }
                responseScores.put(entry2.getValue(), score);
            }
            responseScores.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).forEach(entry -> matchingResponses.add((String)entry.getKey()));
            if (!matchingResponses.isEmpty()) {
                StringBuilder responseBuilder = new StringBuilder();
                responseBuilder.append(this.aiPrefix).append(this.colorize(this.aiChatColor + "I found the following information:\n"));
                for (String response : matchingResponses) {
                    responseBuilder.append(this.colorize(this.aiChatColor + "- " + response)).append("\n");
                }
                player.sendMessage(responseBuilder.toString().trim());
            } else {
                player.sendMessage(this.colorize(this.aiPrefix + this.aiChatColor + "I could not find any information in the knowledge base matching your query."));
            }
            return;
        }
        if (mode.equals("AI_ONLY")) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
                ApiKeyManager.ApiKey apiKey = this.apiKeyManager.getNextAvailableKey(provider);
                if (apiKey == null) {
                    if (this.apiKeyManager.getApiKeys().stream().allMatch(k -> k.getStatus() == ApiKeyManager.ApiKey.Status.RATE_LIMITED)) {
                        player.sendMessage(this.allKeysRateLimitedMessage);
                    } else {
                        player.sendMessage(this.noValidKeysMessage);
                    }
                    return;
                }
                try {
                    String response = switch (apiKey.getType()) {
                        case ApiKeyManager.ApiKey.Type.CLAUDE -> this.callClaudeApi(player, finalMessage, apiKey);
                        case ApiKeyManager.ApiKey.Type.OPENAI -> this.callOpenAIApi(player, finalMessage, apiKey);
                        default -> this.callGeminiApi(player, finalMessage, apiKey);
                    };
                    this.conversationManager.addMessage(player.getUniqueId(), new ConversationManager.Message("user", finalMessage));
                    String finalResponse = this.filterCodeSnippets(response, isAdmin);
                    Bukkit.getScheduler().runTask((Plugin)this, () -> {
                        String[] lines;
                        for (String line : lines = finalResponse.split("\\n")) {
                            if (isAdmin) {
                                player.sendMessage(this.colorize(this.adminAiPrefix + this.aiChatColor + line));
                                continue;
                            }
                            player.sendMessage(this.colorize(this.aiPrefix + this.aiChatColor + line));
                        }
                    });
                }
                catch (IOException e) {
                    this.getLogger().log(Level.SEVERE, "Error calling AI API", e);
                    player.sendMessage(this.apiErrorMessage + " Details: " + e.getMessage());
                }
            });
        }
    }

    private String filterCodeSnippets(String response, boolean isAdmin) {
        if (isAdmin) {
            return response;
        }
        if (response == null) {
            return "";
        }
        if (response.matches(".*```[\\w\\W]*?```.*")) {
            return this.codeBlockerMessage;
        }
        return response;
    }

    private String callGeminiApi(Player player, String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        prompt = "My name is " + player.getName() + ". " + (String)prompt;
        String url = "https://generativelanguage.googleapis.com/v1/models/" + this.defaultGeminiModel + ":generateContent?key=" + apiKey.getKey();
        JsonArray contents = new JsonArray();
        List<ConversationManager.Message> history = this.conversationManager.getHistory(player.getUniqueId());
        for (ConversationManager.Message msg : history) {
            JsonObject message = new JsonObject();
            message.addProperty("role", msg.getRole());
            JsonObject part = new JsonObject();
            part.addProperty("text", msg.getContent());
            message.add("parts", this.gson.toJsonTree(new JsonObject[]{part}));
            contents.add(message);
        }
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        JsonObject userPart = new JsonObject();
        userPart.addProperty("text", (String)prompt);
        userMessage.add("parts", this.gson.toJsonTree(new JsonObject[]{userPart}));
        contents.add(userMessage);
        JsonObject requestBody = new JsonObject();
        requestBody.add("contents", contents);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(body).build();
        int retries = 0;
        while (retries < 3) {
            Response response = this.httpClient.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    String errorBody = response.body() != null ? response.body().string() : "N/A";
                    this.getLogger().log(Level.WARNING, "Gemini API Error (Attempt " + (retries + 1) + "): " + response.code() + " - " + response.message() + " Body: " + errorBody);
                    if (response.code() == 429 || response.code() >= 500) {
                        ++retries;
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            throw new IOException("API call interrupted during retry.", ie);
                        }
                    }
                    throw new IOException("API Error: " + response.code() + " - " + response.message() + " Body: " + errorBody);
                }
                String responseBody = response.body().string();
                JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
                String string = jsonResponse.getAsJsonArray("candidates").get(0).getAsJsonObject().getAsJsonObject("content").getAsJsonArray("parts").get(0).getAsJsonObject().get("text").getAsString();
                return string;
            }
            finally {
                if (response == null) continue;
                response.close();
            }
        }
        throw new IOException("Gemini API call failed after 3 retries.");
    }

    private String callClaudeApi(Player player, String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        prompt = "My name is " + player.getName() + ". " + (String)prompt;
        String url = "https://api.anthropic.com/v1/messages";
        JsonArray messages = new JsonArray();
        if (this.systemPrompt != null && !this.systemPrompt.isEmpty()) {
            JsonObject systemMessage = new JsonObject();
            systemMessage.addProperty("role", "system");
            systemMessage.addProperty("content", this.systemPrompt);
            messages.add(systemMessage);
        }
        List<ConversationManager.Message> history = this.conversationManager.getHistory(player.getUniqueId());
        for (ConversationManager.Message msg : history) {
            JsonObject message = new JsonObject();
            message.addProperty("role", msg.getRole());
            message.addProperty("content", msg.getContent());
            messages.add(message);
        }
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        userMessage.addProperty("content", (String)prompt);
        messages.add(userMessage);
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("model", this.defaultClaudeModel);
        requestBody.addProperty("max_tokens", 1024);
        requestBody.add("messages", messages);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).header("x-api-key", apiKey.getKey()).header("anthropic-version", "2023-06-01").post(body).build();
        int retries = 0;
        while (retries < 3) {
            Response response = this.httpClient.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    String errorBody = response.body() != null ? response.body().string() : "N/A";
                    this.getLogger().log(Level.WARNING, "Claude API Error (Attempt " + (retries + 1) + "): " + response.code() + " - " + response.message() + " Body: " + errorBody);
                    if (response.code() == 429 || response.code() >= 500) {
                        ++retries;
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            throw new IOException("API call interrupted during retry.", ie);
                        }
                    }
                    throw new IOException("API Error: " + response.code() + " - " + response.message() + " Body: " + errorBody);
                }
                String responseBody = response.body().string();
                JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
                String string = jsonResponse.getAsJsonArray("content").get(0).getAsJsonObject().get("text").getAsString();
                return string;
            }
            finally {
                if (response == null) continue;
                response.close();
            }
        }
        throw new IOException("Claude API call failed after 3 retries.");
    }

    private String callOpenAIApi(Player player, String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        prompt = "My name is " + player.getName() + ". " + (String)prompt;
        String url = "https://api.openai.com/v1/chat/completions";
        JsonArray messages = new JsonArray();
        if (this.systemPrompt != null && !this.systemPrompt.isEmpty()) {
            JsonObject systemMessage = new JsonObject();
            systemMessage.addProperty("role", "system");
            systemMessage.addProperty("content", this.systemPrompt);
            messages.add(systemMessage);
        }
        List<ConversationManager.Message> history = this.conversationManager.getHistory(player.getUniqueId());
        for (ConversationManager.Message msg : history) {
            JsonObject message = new JsonObject();
            message.addProperty("role", msg.getRole());
            message.addProperty("content", msg.getContent());
            messages.add(message);
        }
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        userMessage.addProperty("content", (String)prompt);
        messages.add(userMessage);
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("model", this.defaultOpenAIModel);
        requestBody.add("messages", messages);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).header("Authorization", "Bearer " + apiKey.getKey()).post(body).build();
        int retries = 0;
        while (retries < 3) {
            Response response = this.httpClient.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    String errorBody = response.body() != null ? response.body().string() : "N/A";
                    this.getLogger().log(Level.WARNING, "OpenAI API Error (Attempt " + (retries + 1) + "): " + response.code() + " - " + response.message() + " Body: " + errorBody);
                    if (response.code() == 429 || response.code() >= 500) {
                        ++retries;
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            throw new IOException("API call interrupted during retry.", ie);
                        }
                    }
                    throw new IOException("API Error: " + response.code() + " - " + response.message() + " Body: " + errorBody);
                }
                String responseBody = response.body().string();
                JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
                String string = jsonResponse.getAsJsonArray("choices").get(0).getAsJsonObject().getAsJsonObject("message").get("content").getAsString();
                return string;
            }
            finally {
                if (response == null) continue;
                response.close();
            }
        }
        throw new IOException("OpenAI API call failed after 3 retries.");
    }

    public String generateAIHeading(String originalContent, String aiResponse, String keyword) {
        String prompt = "Generate a descriptive and concise heading (single phrase or short sentence) for the following knowledge base entry. The heading should accurately summarize the content and be suitable for a knowledge base key. Consider the provided keyword for context.\nKeyword: " + keyword + "\nOriginal Content: " + originalContent + "\nAI Response: " + aiResponse + "\nHeading:";
        String model = this.defaultGeminiModel;
        ApiKeyManager.ApiKey apiKey = this.apiKeyManager.getNextAvailableKey(this.defaultApiProvider);
        if (apiKey == null) {
            this.getLogger().log(Level.WARNING, "No valid API key available for AI heading generation.");
            return "Generated Heading";
        }
        try {
            return (switch (apiKey.getType()) {
                case ApiKeyManager.ApiKey.Type.CLAUDE -> this.callClaudeApiForHeading(prompt, apiKey);
                case ApiKeyManager.ApiKey.Type.OPENAI -> this.callOpenAIApiForHeading(prompt, apiKey);
                default -> this.callGeminiApiForHeading(prompt, apiKey);
            }).trim();
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Error generating AI heading: " + e.getMessage(), e);
            return "Generated Heading";
        }
    }

    public String getCorrectedContent(String originalContent) {
        String prompt = "You are a grammar and spelling correction tool. Your task is to correct the following text. Do not add any new information, commentary, or change the meaning. Only output the corrected text.\n\nExample:\nOriginal Text: that punsihment are no griefing 7 dyas ban\nCorrected Text: The punishment for griefing is a 7-day ban.\n\nOriginal Text: " + originalContent + "\nCorrected Text:";
        String model = this.defaultGeminiModel;
        ApiKeyManager.ApiKey apiKey = this.apiKeyManager.getNextAvailableKey(this.defaultApiProvider);
        if (apiKey == null) {
            this.getLogger().log(Level.WARNING, "No valid API key available for content correction.");
            return originalContent;
        }
        try {
            return (switch (apiKey.getType()) {
                case ApiKeyManager.ApiKey.Type.CLAUDE -> this.callClaudeApiForCorrection(prompt, apiKey);
                case ApiKeyManager.ApiKey.Type.OPENAI -> this.callOpenAIApiForCorrection(prompt, apiKey);
                default -> this.callGeminiApiForCorrection(prompt, apiKey);
            }).trim();
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Error correcting content: " + e.getMessage(), e);
            return originalContent;
        }
    }

    private String callGeminiApiForCorrection(String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        String url = "https://generativelanguage.googleapis.com/v1/models/" + this.defaultGeminiModel + ":generateContent?key=" + apiKey.getKey();
        JsonObject requestBody = new JsonObject();
        JsonArray contents = new JsonArray();
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        JsonObject userPart = new JsonObject();
        userPart.addProperty("text", prompt);
        userMessage.add("parts", this.gson.toJsonTree(new JsonObject[]{userPart}));
        contents.add(userMessage);
        requestBody.add("contents", contents);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("API Error: " + response.code() + " - " + response.message());
            }
            String responseBody = response.body().string();
            JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
            String string = jsonResponse.getAsJsonArray("candidates").get(0).getAsJsonObject().getAsJsonObject("content").getAsJsonArray("parts").get(0).getAsJsonObject().get("text").getAsString();
            return string;
        }
    }

    private String callClaudeApiForCorrection(String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        String url = "https://api.anthropic.com/v1/messages";
        JsonObject requestBody = new JsonObject();
        JsonArray messages = new JsonArray();
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        userMessage.addProperty("content", prompt);
        messages.add(userMessage);
        requestBody.addProperty("model", this.defaultClaudeModel);
        requestBody.addProperty("max_tokens", 1024);
        requestBody.add("messages", messages);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).header("x-api-key", apiKey.getKey()).header("anthropic-version", "2023-06-01").post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("API Error: " + response.code() + " " + response.message());
            }
            String responseBody = response.body().string();
            JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
            String string = jsonResponse.getAsJsonArray("content").get(0).getAsJsonObject().get("text").getAsString();
            return string;
        }
    }

    private String callOpenAIApiForCorrection(String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        String url = "https://api.openai.com/v1/chat/completions";
        JsonObject requestBody = new JsonObject();
        JsonArray messages = new JsonArray();
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        userMessage.addProperty("content", prompt);
        messages.add(userMessage);
        requestBody.addProperty("model", this.defaultOpenAIModel);
        requestBody.add("messages", messages);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).header("Authorization", "Bearer " + apiKey.getKey()).post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("API Error: " + response.code() + " " + response.message());
            }
            String responseBody = response.body().string();
            JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
            String string = jsonResponse.getAsJsonArray("choices").get(0).getAsJsonObject().getAsJsonObject("message").get("content").getAsString();
            return string;
        }
    }

    private String callGeminiApiForHeading(String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        String url = "https://generativelanguage.googleapis.com/v1/models/" + this.defaultGeminiModel + ":generateContent?key=" + apiKey.getKey();
        JsonObject requestBody = new JsonObject();
        JsonArray contents = new JsonArray();
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        JsonObject userPart = new JsonObject();
        userPart.addProperty("text", prompt);
        userMessage.add("parts", this.gson.toJsonTree(new JsonObject[]{userPart}));
        contents.add(userMessage);
        requestBody.add("contents", contents);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("API Error: " + response.code() + " - " + response.message());
            }
            String responseBody = response.body().string();
            JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
            String string = jsonResponse.getAsJsonArray("candidates").get(0).getAsJsonObject().getAsJsonObject("content").getAsJsonArray("parts").get(0).getAsJsonObject().get("text").getAsString();
            return string;
        }
    }

    private String callClaudeApiForHeading(String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        String url = "https://api.anthropic.com/v1/messages";
        JsonObject requestBody = new JsonObject();
        JsonArray messages = new JsonArray();
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        userMessage.addProperty("content", prompt);
        messages.add(userMessage);
        requestBody.addProperty("model", this.defaultClaudeModel);
        requestBody.addProperty("max_tokens", 100);
        requestBody.add("messages", messages);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).header("x-api-key", apiKey.getKey()).header("anthropic-version", "2023-06-01").post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("API Error: " + response.code() + " " + response.message());
            }
            String responseBody = response.body().string();
            JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
            String string = jsonResponse.getAsJsonArray("content").get(0).getAsJsonObject().get("text").getAsString();
            return string;
        }
    }

    private String callOpenAIApiForHeading(String prompt, ApiKeyManager.ApiKey apiKey) throws IOException {
        String url = "https://api.openai.com/v1/chat/completions";
        JsonObject requestBody = new JsonObject();
        JsonArray messages = new JsonArray();
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        userMessage.addProperty("content", prompt);
        messages.add(userMessage);
        requestBody.addProperty("model", this.defaultOpenAIModel);
        requestBody.add("messages", messages);
        RequestBody body = RequestBody.create(this.gson.toJson(requestBody), MediaType.get("application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).header("Authorization", "Bearer " + apiKey.getKey()).post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("API Error: " + response.code() + " " + response.message());
            }
            String responseBody = response.body().string();
            JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
            String string = jsonResponse.getAsJsonArray("choices").get(0).getAsJsonObject().getAsJsonObject("message").get("content").getAsString();
            return string;
        }
    }

    public AddonManager getAddonManager() {
        return this.addonManager;
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.adminModePlayers.containsKey(player.getUniqueId())) {
            this.adminModePlayers.remove(player.getUniqueId());
            player.sendMessage(this.colorize("&aYour admin mode has been automatically disabled due to quitting the server."));
        }
        this.conversationManager.clearHistory(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        Player player = event.getPlayer();
        if (event.isSneaking() && this.adminModePlayers.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            this.adminModePlayers.remove(player.getUniqueId());
            player.sendMessage(this.colorize("&aYour admin mode has been automatically disabled due to crouching."));
        }
    }

    private void updateConfig() {
    }

    @Override
    public Plugin getPlugin() {
        return this;
    }

    public ChatHistoryManager getChatHistoryManager() {
        return this.chatHistoryManager;
    }

    @Override
    public String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public String refineResponse(String response, String userQuery) {
        if (userQuery.toLowerCase().contains("date") && response.matches(".*\\d{4}-\\d{2}-\\d{2}.*\\d{2}:\\d{2}:\\d{2}.*")) {
            try {
                Pattern pattern = Pattern.compile("(\\d{4}-\\d{2}-\\d{2})");
                Matcher matcher = pattern.matcher(response);
                if (matcher.find()) {
                    return matcher.group(1);
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Error refining date from response: " + e.getMessage());
            }
        }
        return response;
    }

    public void saveKnowledgeBase() {
        this.getLogger().info("Saving knowledge base to knowledge.yml. Size: " + this.knowledgeBase.size());
        for (Map.Entry<String, String> entry : this.knowledgeBase.entrySet()) {
            this.getLogger().info("Setting in knowledgeConfig: " + entry.getKey());
            this.knowledgeConfig.set(entry.getKey(), (Object)entry.getValue());
        }
        try {
            this.knowledgeConfig.save(this.knowledgeFile);
            this.getLogger().info("knowledge.yml saved successfully.");
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Could not save knowledge.yml", e);
        }
    }

    public void addKnowledgeEntry(String keyword, String aiGeneratedHeading, String aiResponse) {
        String compositeKey = keyword.toLowerCase() + "/" + aiGeneratedHeading.toLowerCase();
        this.getLogger().info("Adding to knowledgeBase map: " + compositeKey);
        this.knowledgeBase.put(compositeKey, aiResponse);
        this.saveKnowledgeBase();
        this.loadKnowledgeBase();
    }

    public boolean removeKnowledgeEntry(String key) {
        boolean removed;
        boolean bl = removed = this.knowledgeBase.remove(key.toLowerCase()) != null;
        if (removed) {
            this.knowledgeConfig.set(key.toLowerCase(), null);
            this.getLogger().info("Attempting to remove key '" + key.toLowerCase() + "' from knowledgeConfig. Contains key before save: " + this.knowledgeConfig.contains(key.toLowerCase()));
            this.saveKnowledgeBase();
            this.getLogger().info("Key '" + key.toLowerCase() + "' removed from knowledgeConfig after save: " + !this.knowledgeConfig.contains(key.toLowerCase()));
            this.loadKnowledgeBase();
        }
        return removed;
    }

    public Map<String, String> getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public String getAdminActivationCode() {
        return this.adminActivationCode;
    }

    public Map<UUID, Boolean> getAdminModePlayers() {
        return this.adminModePlayers;
    }

    public ApiKeyManager getApiKeyManager() {
        return this.apiKeyManager;
    }

    @Override
    public String getPermissionDeniedMessage() {
        return this.permissionDeniedMessage;
    }

    public ConversationManager getConversationManager() {
        return this.conversationManager;
    }

    public List<String> getApiKeys() {
        return this.apiKeys;
    }

    public String getAiNotConfiguredMessage() {
        return this.aiNotConfiguredMessage;
    }

    public String getDefaultApiProvider() {
        return this.defaultApiProvider;
    }

    public String getUserPrefix() {
        return this.userPrefix;
    }

    public String getUserChatColor() {
        return this.userChatColor;
    }

    public String getAdminAiPrefix() {
        return this.adminAiPrefix;
    }

    public String getAiPrefix() {
        return this.aiPrefix;
    }

    public String getAiChatColor() {
        return this.aiChatColor;
    }

    @Override
    public Economy getEconomy() {
        return null;
    }

    public ConfirmationManager getConfirmationManager() {
        return this.confirmationManager;
    }
}

