/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.command;

import com.nsr.ai.plugin.ApiKeyManager;
import com.nsr.ai.plugin.NSRAIPlugin;
import com.nsr.ai.plugin.addons.Addon;
import com.nsr.ai.plugin.util.ConfirmationEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandManager
implements CommandExecutor {
    private final NSRAIPlugin plugin;
    private final Logger logger;

    public CommandManager(NSRAIPlugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
    }

    private Logger getLogger() {
        return this.logger;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        String response;
        if (!command.getName().equalsIgnoreCase("ai")) {
            return false;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        UUID playerUUID = player.getUniqueId();
        String confirmationCode = null;
        if (args2.length > 0) {
            String lowerCaseArg;
            switch (lowerCaseArg = args2[0].toLowerCase()) {
                case "admin": {
                    if (args2.length > 1 && args2[1].equals(this.plugin.getAdminActivationCode())) {
                        this.plugin.getAdminModePlayers().put(playerUUID, true);
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Admin mode activated.");
                        this.plugin.getChatHistoryManager().logAdminChat(player, "Activated admin mode.");
                    } else if (args2.length > 1 && args2[1].equalsIgnoreCase("status")) {
                        if (player.hasPermission("nsr-ai.admin")) {
                            player.sendMessage(String.valueOf(ChatColor.GOLD) + "--- API Key Status ---");
                            List<ApiKeyManager.ApiKey> keys2 = this.plugin.getApiKeyManager().getApiKeys();
                            for (int i = 0; i < keys2.size(); ++i) {
                                ApiKeyManager.ApiKey key = keys2.get(i);
                                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "API Key " + (i + 1) + ": " + String.valueOf((Object)key.getStatus()));
                            }
                            this.plugin.getChatHistoryManager().logAdminChat(player, "Checked API key status.");
                        } else {
                            player.sendMessage(this.plugin.getPermissionDeniedMessage());
                        }
                    } else {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid admin command or code.");
                    }
                    return true;
                }
                case "disable": {
                    if (this.plugin.getAdminModePlayers().containsKey(playerUUID)) {
                        this.plugin.getAdminModePlayers().remove(playerUUID);
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Admin mode disabled.");
                        this.plugin.getChatHistoryManager().logAdminChat(player, "Disabled admin mode via command.");
                    } else {
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "You are not currently in admin mode.");
                    }
                    return true;
                }
                case "reload": {
                    if (player.hasPermission("nsr-ai.reload")) {
                        this.plugin.reloadConfig();
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "NSR-AI config reloaded successfully!");
                        this.plugin.getChatHistoryManager().logAdminChat(player, "Reloaded plugin configuration.");
                    } else {
                        player.sendMessage(this.plugin.getPermissionDeniedMessage());
                    }
                    return true;
                }
                case "add": {
                    String[] lines;
                    if (!this.plugin.getAdminModePlayers().getOrDefault(playerUUID, false).booleanValue()) {
                        player.sendMessage(this.plugin.getPermissionDeniedMessage());
                        return true;
                    }
                    if (!player.hasPermission("nsr-ai.admin.add")) {
                        player.sendMessage(this.plugin.getPermissionDeniedMessage());
                        return true;
                    }
                    if (args2.length < 2) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai add <content to add to knowledge base>");
                        return true;
                    }
                    String originalContent = String.join((CharSequence)" ", Arrays.copyOfRange(args2, 1, args2.length));
                    player.sendMessage(this.plugin.colorize(this.plugin.getUserPrefix() + this.plugin.getUserChatColor() + originalContent));
                    String aiResponse = this.plugin.getCorrectedContent(originalContent);
                    confirmationCode = this.plugin.getConfirmationManager().createConfirmation(playerUUID, "add", originalContent, aiResponse);
                    for (String line : lines = aiResponse.split("\\n")) {
                        player.sendMessage(this.plugin.colorize(this.plugin.getAdminAiPrefix() + this.plugin.getAiChatColor() + line));
                    }
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "AI processed content. Confirmation required! Type /ai confirm " + confirmationCode + " <keyword> to add this entry permanently. Code expires in 1 hour.");
                    this.plugin.getChatHistoryManager().logAdminChat(player, "Attempted to add knowledge entry: " + originalContent + ". AI Response: " + aiResponse + ". Confirmation code: " + confirmationCode);
                    return true;
                }
                case "remove": {
                    if (!this.plugin.getAdminModePlayers().getOrDefault(playerUUID, false).booleanValue()) {
                        player.sendMessage(this.plugin.getPermissionDeniedMessage());
                        return true;
                    }
                    if (!player.hasPermission("nsr-ai.admin.remove")) {
                        player.sendMessage(this.plugin.getPermissionDeniedMessage());
                        return true;
                    }
                    if (args2.length < 2) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai remove <question>");
                        return true;
                    }
                    String questionToRemove = String.join((CharSequence)" ", Arrays.copyOfRange(args2, 1, args2.length));
                    ArrayList<String> matchingKeys = new ArrayList<String>();
                    for (Map.Entry<String, String> entry : this.plugin.getKnowledgeBase().entrySet()) {
                        if (!entry.getKey().toLowerCase().contains(questionToRemove.toLowerCase())) continue;
                        matchingKeys.add(entry.getKey());
                    }
                    if (matchingKeys.isEmpty()) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "No knowledge entries found matching '" + questionToRemove + "'.");
                        return true;
                    }
                    if (matchingKeys.size() == 1) {
                        String keyToRemove = (String)matchingKeys.get(0);
                        confirmationCode = this.plugin.getConfirmationManager().createConfirmation(playerUUID, "remove", keyToRemove, null);
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Found one matching entry:");
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "  Key: " + (String)keyToRemove);
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "  Content: " + this.plugin.getKnowledgeBase().get(keyToRemove));
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "-----------------------------------------------------");
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "CONFIRMATION CODE: " + confirmationCode);
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "-----------------------------------------------------");
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Confirmation required! Type /ai confirm " + confirmationCode + " to remove this entry. Code expires in 1 hour.");
                        this.plugin.getChatHistoryManager().logAdminChat(player, "Attempted to remove knowledge entry: " + (String)keyToRemove + ". Confirmation code: " + confirmationCode);
                    } else {
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Multiple entries found. Please be more specific with your query to narrow it down to a single entry for removal.");
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Matching entries:");
                        for (String key : matchingKeys) {
                            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "- " + key);
                        }
                    }
                    return true;
                }
                case "confirm": {
                    if (args2.length < 2) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai confirm <code> [keyword]");
                        return true;
                    }
                    String confirmCode = args2[1];
                    String confirmKeyword = args2.length > 2 ? args2[2].toLowerCase() : null;
                    ConfirmationEntry entry = this.plugin.getConfirmationManager().getConfirmation(confirmCode);
                    if (entry == null) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid or expired confirmation code.");
                        return true;
                    }
                    if (!entry.getPlayerId().equals(playerUUID)) {
                        player.sendMessage(this.plugin.getPermissionDeniedMessage());
                        return true;
                    }
                    if (entry.getActionType().equals("add")) {
                        if (confirmKeyword == null) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "Error: Keyword is required for adding knowledge entries. Usage: /ai confirm <code> <keyword>");
                            return true;
                        }
                        String aiGeneratedHeading = this.plugin.generateAIHeading(entry.getOriginalContent(), entry.getAiResponse(), confirmKeyword);
                        this.plugin.addKnowledgeEntry(confirmKeyword, aiGeneratedHeading, entry.getAiResponse());
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Knowledge entry '" + confirmKeyword + "/" + aiGeneratedHeading + "' added permanently.");
                        this.plugin.getChatHistoryManager().logAdminChat(player, "Confirmed and added knowledge entry: " + confirmKeyword + "/" + aiGeneratedHeading + ". Original: " + entry.getOriginalContent());
                    } else if (entry.getActionType().equals("remove")) {
                        if (this.plugin.removeKnowledgeEntry(entry.getOriginalContent())) {
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Knowledge entry '" + entry.getOriginalContent() + "' removed permanently.");
                            this.plugin.getChatHistoryManager().logAdminChat(player, "Confirmed and removed knowledge entry: " + entry.getOriginalContent());
                        } else {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "Failed to remove knowledge entry '" + entry.getOriginalContent() + "'. It might have been removed already.");
                        }
                    }
                    this.plugin.getConfirmationManager().removeConfirmation(confirmCode);
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Action confirmed and completed!");
                    return true;
                }
                case "data": {
                    if (args2.length < 2) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai data <question>");
                        return true;
                    }
                    String dataQuestion = String.join((CharSequence)" ", Arrays.copyOfRange(args2, 1, args2.length));
                    this.plugin.handleAIConversation(player, dataQuestion, false, this.plugin.getDefaultApiProvider(), "KNOWLEDGE_ONLY");
                    return true;
                }
            }
        }
        this.getLogger().info("Reached general AI conversation logic with args: " + String.join((CharSequence)" ", args2));
        Addon addon = this.plugin.getAddonManager().getAddon("NSR-AI-Advanced-Player-Stats");
        if (addon != null && (response = addon.onCommand(player, args2)) != null) {
            player.sendMessage(response);
            return true;
        }
        if (this.plugin.getApiKeys().isEmpty() || this.plugin.getApiKeys().get(0).equals("YOUR_API_KEY")) {
            player.sendMessage(this.plugin.getAiNotConfiguredMessage());
            return true;
        }
        String message = String.join((CharSequence)" ", args2);
        String provider = this.plugin.getDefaultApiProvider();
        if (args2.length > 1 && (args2[0].equalsIgnoreCase("gemini") || args2[0].equalsIgnoreCase("claude") || args2[0].equalsIgnoreCase("openai") || args2[0].equalsIgnoreCase("all"))) {
            provider = args2[0].toLowerCase();
            message = String.join((CharSequence)" ", Arrays.copyOfRange(args2, 1, args2.length));
        }
        player.sendMessage(this.plugin.getUserPrefix() + this.plugin.colorize(this.plugin.getUserChatColor() + message));
        this.plugin.handleAIConversation(player, message, this.plugin.getAdminModePlayers().getOrDefault(playerUUID, false), provider, "AI_ONLY");
        return true;
    }
}

