/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.data;

import com.nsr.ai.plugin.NSRAIPlugin;
import com.nsr.ai.plugin.data.DatabaseManager;
import com.nsr.ai.plugin.data.InventorySerializer;
import com.nsr.ai.plugin.data.InventorySnapshotDAO;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.inventory.ItemStack;

public class InventorySnapshotDAOImpl
implements InventorySnapshotDAO {
    private final NSRAIPlugin plugin;
    private final DatabaseManager dbManager;

    public InventorySnapshotDAOImpl(NSRAIPlugin plugin, DatabaseManager dbManager) {
        this.plugin = plugin;
        this.dbManager = dbManager;
    }

    @Override
    public void saveInventorySnapshot(UUID uuid, int snapshotId, ItemStack[] inventory) {
        String sql = "INSERT INTO inventory_snapshots(uuid, id, ts, payload) VALUES(?,?,?,?)";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.setInt(2, snapshotId);
            pstmt.setLong(3, System.currentTimeMillis());
            pstmt.setString(4, InventorySerializer.itemStackArrayToBase64(inventory));
            pstmt.executeUpdate();
        }
        catch (IllegalStateException | SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error saving inventory snapshot for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ItemStack[] getInventorySnapshot(UUID uuid, int snapshotId) {
        String sql = "SELECT payload FROM inventory_snapshots WHERE uuid = ? AND id = ?";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.setInt(2, snapshotId);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return null;
            ItemStack[] itemStackArray = InventorySerializer.itemStackArrayFromBase64(rs.getString("payload"));
            return itemStackArray;
        }
        catch (IOException | SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error retrieving inventory snapshot for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
        return null;
    }

    @Override
    public void deleteOldestSnapshots(UUID uuid, int keepCount) {
        String sql = "DELETE FROM inventory_snapshots WHERE id IN (SELECT id FROM inventory_snapshots WHERE uuid = ? ORDER BY ts ASC LIMIT (SELECT COUNT(*) FROM inventory_snapshots WHERE uuid = ?) - ?)";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.setString(2, uuid.toString());
            pstmt.setInt(3, keepCount);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error deleting oldest inventory snapshots for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
    }
}

