/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.data;

import com.nsr.ai.plugin.NSRAIPlugin;
import com.nsr.ai.plugin.data.DatabaseManager;
import com.nsr.ai.plugin.data.StatDAO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;

public class StatDAOImpl
implements StatDAO {
    private final NSRAIPlugin plugin;
    private final DatabaseManager dbManager;

    public StatDAOImpl(NSRAIPlugin plugin, DatabaseManager dbManager) {
        this.plugin = plugin;
        this.dbManager = dbManager;
    }

    @Override
    public void incrementStat(UUID uuid, String key, long amount) {
        String sql = "INSERT INTO stats(uuid, key, value) VALUES(?, ?, ?) ON CONFLICT(uuid, key) DO UPDATE SET value = value + ?";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.setString(2, key);
            pstmt.setLong(3, amount);
            pstmt.setLong(4, amount);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error incrementing stat " + key + " for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
    }

    @Override
    public void setStat(UUID uuid, String key, long value) {
        String sql = "INSERT INTO stats(uuid, key, value) VALUES(?, ?, ?) ON CONFLICT(uuid, key) DO UPDATE SET value = ?";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.setString(2, key);
            pstmt.setLong(3, value);
            pstmt.setLong(4, value);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error setting stat " + key + " for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getStat(UUID uuid, String key) {
        String sql = "SELECT value FROM stats WHERE uuid = ? AND key = ?";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.setString(2, key);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return 0L;
            long l = rs.getLong("value");
            return l;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting stat " + key + " for " + String.valueOf(uuid) + ": " + e.getMessage(), e);
        }
        return 0L;
    }

    @Override
    public List<Map.Entry<UUID, Long>> getTopStats(String key, int limit) {
        ArrayList<Map.Entry<UUID, Long>> topStats = new ArrayList<Map.Entry<UUID, Long>>();
        String sql = "SELECT uuid, value FROM stats WHERE key = ? ORDER BY value DESC LIMIT ?";
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, key);
            pstmt.setInt(2, limit);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                UUID uuid = UUID.fromString(rs.getString("uuid"));
                long value = rs.getLong("value");
                topStats.add(new AbstractMap.SimpleEntry<UUID, Long>(uuid, value));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting top stats for key " + key + ": " + e.getMessage(), e);
        }
        return topStats;
    }
}

