/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.managers;

import com.nsr.ai.plugin.NSRAIPlugin;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class AddonManager {
    private final NSRAIPlugin plugin;
    private final Map<String, AddonInfo> addonFeatures = new HashMap<String, AddonInfo>();

    public AddonManager(NSRAIPlugin plugin) {
        this.plugin = plugin;
        this.loadAddonFeatures();
    }

    private void loadAddonFeatures() {
        String commandsProMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)"&eThis is part of the &bCommands Pro &eAdd-on. With it, AI can run complex commands easily.\n&7Examples:\n- Run /give Steve diamond_sword even if you type /giv steve daimond swerd.\n- Execute /time set day and /weather clear in one chat message.\n- Automatically run /heal if a player\u2019s health drops below 5.");
        this.addonFeatures.put("heal", new AddonInfo("NSR-AI-Commands-Pro", commandsProMessage));
        this.addonFeatures.put("fix command", new AddonInfo("NSR-AI-Commands-Pro", commandsProMessage));
        this.addonFeatures.put("multiple commands", new AddonInfo("NSR-AI-Commands-Pro", commandsProMessage));
        String advancedStatsMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)"&eThat\u2019s in the &bAdvanced Player Stats &eAdd-on. It tracks players like never before.\n&7Examples:\n- Show top 5 richest players based on economy balance.\n- Display K/D ratio of a player.\n- Track blocks mined and distance traveled in real time.");
        this.addonFeatures.put("leaderboard", new AddonInfo("NSR-AI-Advanced-Player-Stats", advancedStatsMessage));
        this.addonFeatures.put("k/d", new AddonInfo("NSR-AI-Advanced-Player-Stats", advancedStatsMessage));
        this.addonFeatures.put("richest", new AddonInfo("NSR-AI-Advanced-Player-Stats", advancedStatsMessage));
        this.addonFeatures.put("blocks mined", new AddonInfo("NSR-AI-Advanced-Player-Stats", advancedStatsMessage));
        this.addonFeatures.put("kills", new AddonInfo("NSR-AI-Advanced-Player-Stats", advancedStatsMessage));
        this.addonFeatures.put("deaths", new AddonInfo("NSR-AI-Advanced-Player-Stats", advancedStatsMessage));
        String fileReadingMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)"&eThe &bFile Reading & Knowledge &eAdd-on lets me open and analyze server files.\n&7Examples:\n- Read server.properties to check current settings.\n- Scan latest.log for errors.\n- Suggest better values for spigot.yml performance tweaks.");
        this.addonFeatures.put("read file", new AddonInfo("NSR-AI-File-Reading-Knowledge", fileReadingMessage));
        this.addonFeatures.put("read config", new AddonInfo("NSR-AI-File-Reading-Knowledge", fileReadingMessage));
        this.addonFeatures.put("check log", new AddonInfo("NSR-AI-File-Reading-Knowledge", fileReadingMessage));
        String adminToolkitMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)"&eThat\u2019s in the &bAdmin AI Toolkit &eAdd-on, perfect for server security.\n&7Examples:\n- Detect if a player is AFK for too long and kick them.\n- Alert admin if someone moves too fast (speed hacks).\n- Track a specific player\u2019s location in real time.");
        this.addonFeatures.put("kick afk", new AddonInfo("NSR-AI-Admin-AI-Toolkit", adminToolkitMessage));
        this.addonFeatures.put("detect cheats", new AddonInfo("NSR-AI-Admin-AI-Toolkit", adminToolkitMessage));
        this.addonFeatures.put("track player", new AddonInfo("NSR-AI-Admin-AI-Toolkit", adminToolkitMessage));
        String apiExpansionMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)"&eWith the &bAPI Expansion &eAdd-on, you can connect more AI accounts for faster responses.\n&7Examples:\n- Add up to 100 API keys instead of 30.\n- Use both Gemini and OpenAI in one server.\n- Prioritize fastest key for near-instant replies.");
        this.addonFeatures.put("expand api", new AddonInfo("NSR-AI-API-Expansion", apiExpansionMessage));
        this.addonFeatures.put("add more keys", new AddonInfo("NSR-AI-API-Expansion", apiExpansionMessage));
    }

    public boolean checkForAddonCommand(Player player, String message) {
        String lowerCaseMessage = message.toLowerCase();
        for (Map.Entry<String, AddonInfo> entry : this.addonFeatures.entrySet()) {
            if (!lowerCaseMessage.contains(entry.getKey())) continue;
            player.sendMessage(entry.getValue().getMessage());
            return true;
        }
        return false;
    }

    private static class AddonInfo {
        private final String addonName;
        private final String message;

        public AddonInfo(String addonName, String message) {
            this.addonName = addonName;
            this.message = message;
        }

        public String getAddonName() {
            return this.addonName;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

