/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.managers;

import com.nsr.ai.plugin.NSRAIPlugin;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class DataManager {
    private final NSRAIPlugin plugin;
    private final File dataFolder;
    private final Map<String, FileConfiguration> playerConfigs = new HashMap<String, FileConfiguration>();

    public DataManager(NSRAIPlugin plugin) {
        this.plugin = plugin;
        this.dataFolder = new File(plugin.getDataFolder(), "playerdata");
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdirs();
        }
    }

    public FileConfiguration getPlayerConfig(String playerName) {
        if (!this.playerConfigs.containsKey(playerName)) {
            File playerFile = new File(this.dataFolder, playerName + ".yml");
            if (!playerFile.exists()) {
                try {
                    playerFile.createNewFile();
                }
                catch (IOException e) {
                    this.plugin.getLogger().severe("Could not create player data file for " + playerName);
                }
            }
            this.playerConfigs.put(playerName, (FileConfiguration)YamlConfiguration.loadConfiguration((File)playerFile));
        }
        return this.playerConfigs.get(playerName);
    }

    public void savePlayerConfig(String playerName) {
        if (this.playerConfigs.containsKey(playerName)) {
            File playerFile = new File(this.dataFolder, playerName + ".yml");
            try {
                this.playerConfigs.get(playerName).save(playerFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not save player data file for " + playerName);
            }
        }
    }
}

