/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.managers;

import com.nsr.ai.plugin.NSRAIPlugin;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class KnowledgeManager {
    private final NSRAIPlugin plugin;
    private File knowledgeFile;
    private FileConfiguration knowledgeConfig;
    private Map<String, String> knowledgeBase;
    private Map<String, String> adminKnowledgeBase;

    public KnowledgeManager(NSRAIPlugin plugin) {
        this.plugin = plugin;
        this.knowledgeBase = new HashMap<String, String>();
        this.adminKnowledgeBase = new HashMap<String, String>();
        this.loadKnowledgeBase();
    }

    private void loadKnowledgeBase() {
        String fileName = this.plugin.getConfig().getString("knowledge-file", "knowledge.yml");
        this.knowledgeFile = new File(this.plugin.getDataFolder(), fileName);
        if (!this.knowledgeFile.exists()) {
            try {
                this.knowledgeFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create knowledge file: " + e.getMessage());
            }
        }
        this.knowledgeConfig = YamlConfiguration.loadConfiguration((File)this.knowledgeFile);
        if (this.knowledgeConfig.isConfigurationSection("knowledge")) {
            for (String key : this.knowledgeConfig.getConfigurationSection("knowledge").getKeys(false)) {
                this.knowledgeBase.put(key.toLowerCase(), this.knowledgeConfig.getString("knowledge." + key));
            }
        }
        if (this.knowledgeConfig.isConfigurationSection("admin-knowledge")) {
            for (String key : this.knowledgeConfig.getConfigurationSection("admin-knowledge").getKeys(false)) {
                this.adminKnowledgeBase.put(key.toLowerCase(), this.knowledgeConfig.getString("admin-knowledge." + key));
            }
        }
    }

    public void saveKnowledgeBase() {
        this.knowledgeConfig.set("knowledge", this.knowledgeBase);
        this.knowledgeConfig.set("admin-knowledge", this.adminKnowledgeBase);
        try {
            this.knowledgeConfig.save(this.knowledgeFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save knowledge file: " + e.getMessage());
        }
    }

    public void addKnowledge(String question, String answer, boolean isAdminKnowledge) {
        if (isAdminKnowledge) {
            this.adminKnowledgeBase.put(question.toLowerCase(), answer);
        } else {
            this.knowledgeBase.put(question.toLowerCase(), answer);
        }
        this.saveKnowledgeBase();
    }

    public String getAnswer(String question, boolean isAdmin) {
        String adminAnswer;
        if (isAdmin && (adminAnswer = this.adminKnowledgeBase.get(question.toLowerCase())) != null) {
            return adminAnswer;
        }
        return this.knowledgeBase.get(question.toLowerCase());
    }
}

