/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.managers;

import com.nsr.ai.plugin.NSRAIPlugin;
import com.nsr.ai.plugin.PlayerData;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PlayerDataManager {
    private final NSRAIPlugin plugin;
    private final File playerDataFolder;

    public PlayerDataManager(NSRAIPlugin plugin) {
        this.plugin = plugin;
        this.playerDataFolder = new File(plugin.getDataFolder(), "playerdata");
        if (!this.playerDataFolder.exists()) {
            this.playerDataFolder.mkdirs();
        }
    }

    public PlayerData getPlayerData(Player player) {
        File playerFile = new File(this.playerDataFolder, player.getUniqueId().toString() + ".yml");
        if (!playerFile.exists()) {
            return new PlayerData(player.getName());
        }
        YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)playerFile);
        PlayerData data = new PlayerData(player.getName());
        data.setTimePlayed(playerConfig.getLong("timePlayed"));
        data.setTimesJoined(playerConfig.getInt("timesJoined"));
        data.setCommandsTyped(playerConfig.getStringList("commandsTyped"));
        data.setHealth(playerConfig.getDouble("health"));
        data.setTimesKilled(playerConfig.getInt("timesKilled"));
        data.setPlayersKilled(playerConfig.getInt("playersKilled"));
        data.setLastFiveDeathLocations(playerConfig.getStringList("lastFiveDeathLocations"));
        data.setInventory(playerConfig.getList("inventory"));
        data.setKdRatio(playerConfig.getDouble("kdRatio"));
        data.setBlocksMined(playerConfig.getLong("blocksMined"));
        data.setDistanceTraveled(playerConfig.getDouble("distanceTraveled"));
        data.setEconomyBalance(playerConfig.getDouble("economyBalance"));
        data.setLongestPlaytime(playerConfig.getLong("longestPlaytime"));
        data.setLowestPlaytime(playerConfig.getLong("lowestPlaytime"));
        data.setMobsKilled(playerConfig.getLong("mobsKilled"));
        data.setLastDeathLocation(playerConfig.getString("lastDeathLocation"));
        data.setKilledByPlayer(playerConfig.getString("killedByPlayer"));
        data.setKilledByBoss(playerConfig.getString("killedByBoss"));
        data.setAFK(playerConfig.getBoolean("isAFK"));
        data.setLastActivityTime(playerConfig.getLong("lastActivityTime"));
        return data;
    }

    public void savePlayerData(Player player, PlayerData data) {
        File playerFile = new File(this.playerDataFolder, player.getUniqueId().toString() + ".yml");
        YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)playerFile);
        playerConfig.set("playerName", (Object)data.getPlayerName());
        playerConfig.set("timePlayed", (Object)data.getTimePlayed());
        playerConfig.set("timesJoined", (Object)data.getTimesJoined());
        playerConfig.set("commandsTyped", data.getCommandsTyped());
        playerConfig.set("health", (Object)data.getHealth());
        playerConfig.set("timesKilled", (Object)data.getTimesKilled());
        playerConfig.set("playersKilled", (Object)data.getPlayersKilled());
        playerConfig.set("lastFiveDeathLocations", data.getLastFiveDeathLocations());
        playerConfig.set("inventory", data.getInventory());
        playerConfig.set("kdRatio", (Object)data.getKdRatio());
        playerConfig.set("blocksMined", (Object)data.getBlocksMined());
        playerConfig.set("distanceTraveled", (Object)data.getDistanceTraveled());
        playerConfig.set("economyBalance", (Object)data.getEconomyBalance());
        playerConfig.set("longestPlaytime", (Object)data.getLongestPlaytime());
        playerConfig.set("lowestPlaytime", (Object)data.getLowestPlaytime());
        playerConfig.set("mobsKilled", (Object)data.getMobsKilled());
        playerConfig.set("lastDeathLocation", (Object)data.getLastDeathLocation());
        playerConfig.set("killedByPlayer", (Object)data.getKilledByPlayer());
        playerConfig.set("killedByBoss", (Object)data.getKilledByBoss());
        playerConfig.set("isAFK", (Object)data.isAFK());
        playerConfig.set("lastActivityTime", (Object)data.getLastActivityTime());
        try {
            playerConfig.save(playerFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save player data for " + player.getName());
        }
    }
}

