/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.managers;

import com.nsr.ai.plugin.NSRAIPlugin;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PrivacyManager {
    private final NSRAIPlugin plugin;
    private File privacyFile;
    private FileConfiguration privacyConfig;
    private static final List<String> FEATURES = Arrays.asList("health", "hunger", "deaths", "kills", "kd_ratio", "blocks_mined_placed", "distance_traveled", "playtime", "afk_detection", "streak_counter", "location");

    public PrivacyManager(NSRAIPlugin plugin) {
        this.plugin = plugin;
        this.setupPrivacyConfig();
    }

    private void setupPrivacyConfig() {
        this.privacyFile = new File(this.plugin.getDataFolder(), "privacy.yml");
        if (!this.privacyFile.exists()) {
            this.plugin.saveResource("privacy.yml", false);
        }
        this.privacyConfig = YamlConfiguration.loadConfiguration((File)this.privacyFile);
    }

    public void saveConfig() {
        try {
            this.privacyConfig.save(this.privacyFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save privacy.yml!");
            e.printStackTrace();
        }
    }

    public void reloadConfig() {
        this.privacyConfig = YamlConfiguration.loadConfiguration((File)this.privacyFile);
    }

    public boolean isFeatureEnabled(Player player, String feature) {
        return this.isFeatureEnabled(player.getUniqueId(), feature);
    }

    public boolean isFeatureEnabled(UUID playerUuid, String feature) {
        return this.privacyConfig.getBoolean("players." + playerUuid.toString() + "." + feature, this.privacyConfig.getBoolean("admin.global." + feature, true));
    }

    public void setFeatureEnabled(Player player, String feature, boolean enabled) {
        this.privacyConfig.set("players." + String.valueOf(player.getUniqueId()) + "." + feature, (Object)enabled);
        this.saveConfig();
    }

    public void setAllFeaturesEnabled(Player player, boolean enabled) {
        for (String feature : FEATURES) {
            this.setFeatureEnabled(player, feature, enabled);
        }
    }

    public List<String> getAllFeatures() {
        return FEATURES;
    }

    public long getAfkTimer() {
        return this.privacyConfig.getLong("afk.kick-timer", 8L);
    }
}

