/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.util;

import com.nsr.ai.plugin.NSRAIPlugin;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bukkit.entity.Player;

public class ChatHistoryManager {
    private final NSRAIPlugin plugin;
    private final File playerChatHistoryDir;
    private final File adminChatHistoryDir;

    public ChatHistoryManager(NSRAIPlugin plugin) {
        this.plugin = plugin;
        this.playerChatHistoryDir = new File(plugin.getDataFolder(), "playerchathistory");
        this.adminChatHistoryDir = new File(plugin.getDataFolder(), "adminchathistory");
        if (!this.playerChatHistoryDir.exists()) {
            this.playerChatHistoryDir.mkdirs();
        }
        if (!this.adminChatHistoryDir.exists()) {
            this.adminChatHistoryDir.mkdirs();
        }
    }

    public void logPlayerChat(Player player, String message) {
        this.logChat(player, message, this.playerChatHistoryDir);
    }

    public void logAdminChat(Player player, String message) {
        this.logChat(player, message, this.adminChatHistoryDir);
    }

    private void logChat(Player player, String message, File directory) {
        String fileName = player.getName() + "_" + player.getUniqueId().toString() + ".txt";
        File chatLogFile = new File(directory, fileName);
        String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        String logMessage = "[" + timestamp + "] " + player.getName() + ": " + message + "\n";
        try {
            Files.write(Paths.get(chatLogFile.toURI()), logMessage.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not write to chat history file for " + player.getName());
            e.printStackTrace();
        }
    }
}

