/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.util;

import com.nsr.ai.plugin.NSRAIPlugin;
import com.nsr.ai.plugin.util.ConfirmationEntry;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ConfirmationManager {
    private final NSRAIPlugin plugin;
    private final Map<String, ConfirmationEntry> pendingConfirmations;
    private final long EXPIRATION_TIME_MILLIS = 3600000L;

    public ConfirmationManager(NSRAIPlugin plugin) {
        this.plugin = plugin;
        this.pendingConfirmations = new HashMap<String, ConfirmationEntry>();
        this.startCleanupTask();
    }

    private String generateCode() {
        Random random = new Random();
        int code = 100000 + random.nextInt(900000);
        return String.valueOf(code);
    }

    public String createConfirmation(UUID playerId, String actionType, String originalContent, String aiResponse) {
        String code = this.generateCode();
        while (this.pendingConfirmations.containsKey(code)) {
            code = this.generateCode();
        }
        this.pendingConfirmations.put(code, new ConfirmationEntry(playerId, actionType, originalContent, aiResponse));
        return code;
    }

    public ConfirmationEntry getConfirmation(String code) {
        ConfirmationEntry entry = this.pendingConfirmations.get(code);
        if (entry != null && System.currentTimeMillis() - entry.getTimestamp() > 3600000L) {
            this.pendingConfirmations.remove(code);
            return null;
        }
        return entry;
    }

    public void removeConfirmation(String code) {
        this.pendingConfirmations.remove(code);
    }

    private void startCleanupTask() {
        new BukkitRunnable(){

            public void run() {
                ConfirmationManager.this.pendingConfirmations.entrySet().removeIf(entry -> System.currentTimeMillis() - ((ConfirmationEntry)entry.getValue()).getTimestamp() > 3600000L);
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 6000L, 6000L);
    }
}

