/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin;

import com.nsr.ai.plugin.NSRAIPlugin;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerListener
implements Listener {
    private final NSRAIPlugin plugin;

    public PlayerListener(NSRAIPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        String message = event.getMessage();
        if (message.toLowerCase().startsWith("/ai ")) {
            event.setCancelled(true);
            String formattedUserMessage = this.plugin.colorize(this.plugin.getUserPrefix() + this.plugin.getUserChatColor() + message);
            player.sendMessage(formattedUserMessage);
            String aiMessage = message.substring(4).trim();
            this.plugin.handleAIConversation(player, aiMessage, this.plugin.getAdminModePlayers().getOrDefault(player.getUniqueId(), false), this.plugin.getDefaultApiProvider(), "AI_ONLY");
        } else if (this.plugin.getAdminModePlayers().getOrDefault(player.getUniqueId(), false).booleanValue()) {
            this.plugin.getChatLogger().log(player, event.getMessage(), true, false);
        } else {
            this.plugin.getChatLogger().log(player, event.getMessage(), false, false);
        }
    }

    @EventHandler
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
    }
}

