/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.data;

import com.nsr.ai.plugin.NSRAIPlugin;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class InventorySerializer {
    private static NSRAIPlugin plugin;

    public static void setPlugin(NSRAIPlugin p) {
        plugin = p;
    }

    public static String itemStackArrayToBase64(ItemStack[] items) throws IllegalStateException {
        try {
            ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream2);
            dataOutput.writeInt(items.length);
            for (int i = 0; i < items.length; ++i) {
                dataOutput.writeObject((Object)items[i]);
            }
            return Base64Coder.encodeLines(outputStream2.toByteArray());
        }
        catch (Exception e) {
            if (plugin != null) {
                plugin.getLogger().log(Level.SEVERE, "Error serializing ItemStack array to Base64: " + e.getMessage(), e);
            }
            throw new IllegalStateException("Unable to save item stacks.", e);
        }
    }

    public static ItemStack[] itemStackArrayFromBase64(String data) throws IOException {
        try {
            ByteArrayInputStream inputStream2 = new ByteArrayInputStream(Base64Coder.decodeLines(data));
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream2);
            ItemStack[] items = new ItemStack[dataInput.readInt()];
            for (int i = 0; i < items.length; ++i) {
                items[i] = (ItemStack)dataInput.readObject();
            }
            return items;
        }
        catch (ClassNotFoundException e) {
            if (plugin != null) {
                plugin.getLogger().log(Level.SEVERE, "Error deserializing ItemStack array from Base64: Class not found: " + e.getMessage(), e);
            }
            throw new IOException("Unable to decode class type.", e);
        }
        catch (IOException e) {
            if (plugin != null) {
                plugin.getLogger().log(Level.SEVERE, "Error deserializing ItemStack array from Base64: IO Error: " + e.getMessage(), e);
            }
            throw e;
        }
    }
}

