/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.managers;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nsr.ai.plugin.NSRAIPlugin;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.logging.Level;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class BugFixManager {
    private static final String CLOUDFLARE_BUGFIX_URL = "https://nsr-ai-security.1987sakshamsingh.workers.dev/bugfix_version";
    private final NSRAIPlugin plugin;
    private String currentBugFixVersion = "1.0.3";
    private long lastWarningTime = 0L;
    private final Gson gson = new Gson();
    private final OkHttpClient httpClient = new OkHttpClient();
    private static final String BUGFIX_TXT_FILE_NAME = "bug.txt";

    public BugFixManager(NSRAIPlugin plugin) {
        this.plugin = plugin;
    }

    public String getCurrentBugFixVersion() {
        return this.currentBugFixVersion;
    }

    public void initialize() {
        File bugTxtFile;
        File securityFolder = new File(this.plugin.getDataFolder(), "security");
        if (!securityFolder.exists()) {
            securityFolder.mkdirs();
        }
        if (!(bugTxtFile = new File(securityFolder, BUGFIX_TXT_FILE_NAME)).exists()) {
            this.writeBugTxtVersion(this.plugin.getDescription().getVersion());
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, this::checkForBugFixes);
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::checkForBugFixes, 8400L, 8400L);
    }

    private String readBugTxtVersion() {
        File bugTxtFile = new File(new File(this.plugin.getDataFolder(), "security"), BUGFIX_TXT_FILE_NAME);
        if (bugTxtFile.exists()) {
            try {
                String content = Files.readString(bugTxtFile.toPath()).trim();
                if (content.isEmpty()) {
                    return "0.0.0";
                }
                return content;
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "[BugFixManager] Error reading bug.txt version.", e);
            }
        }
        return "0.0.0";
    }

    private void writeBugTxtVersion(String version) {
        File bugTxtFile = new File(new File(this.plugin.getDataFolder(), "security"), BUGFIX_TXT_FILE_NAME);
        try {
            Files.writeString(bugTxtFile.toPath(), (CharSequence)version, new OpenOption[0]);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "[BugFixManager] Error writing bug.txt version.", e);
        }
    }

    private void checkForBugFixes() {
        block9: {
            try {
                String currentRunningPluginVersion = this.plugin.getDescription().getVersion();
                String installedBugFixVersion = this.readBugTxtVersion();
                if (this.compareVersions(installedBugFixVersion, currentRunningPluginVersion) > 0) {
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - this.lastWarningTime >= 720000L) {
                        this.plugin.getLogger().warning("[BugFixManager] A new bug fix (version " + installedBugFixVersion + ") has been downloaded but the server has not been restarted yet. Please restart your server to apply the update.");
                        this.lastWarningTime = currentTime;
                    }
                    return;
                }
                RemoteBugFixInfo remoteInfo = this.getRemoteBugFixInfo(currentRunningPluginVersion);
                if (remoteInfo == null) {
                    this.plugin.getLogger().warning("[BugFixManager] No remote bug fix info found for plugin version " + currentRunningPluginVersion + ".");
                    return;
                }
                if (this.compareVersions(remoteInfo.version, installedBugFixVersion) > 0) {
                    this.plugin.getLogger().info("[BugFixManager] New bug fix version available: " + remoteInfo.version + ". Downloading...");
                    File newBugFixFile = this.downloadBugFix(remoteInfo.downloadUrl, remoteInfo.version);
                    if (newBugFixFile == null) {
                        this.plugin.getLogger().warning("[BugFixManager] Failed to download new bug fix version.");
                        return;
                    }
                    this.writeBugTxtVersion(remoteInfo.version);
                    this.plugin.getLogger().warning("-----------------------------------------------------");
                    this.plugin.getLogger().warning("[BugFixManager] New main plugin version (with bug fixes) downloaded!");
                    this.plugin.getLogger().warning("[BugFixManager] Latest Bug Fix Version: " + remoteInfo.version);
                    this.plugin.getLogger().warning("[BugFixManager] Downloaded to: " + newBugFixFile.getAbsolutePath());
                    this.plugin.getLogger().warning("[BugFixManager] A server restart is REQUIRED to apply the bug fix update.");
                    this.plugin.getLogger().warning("-----------------------------------------------------");
                    try {
                        File signalFile = new File(new File(this.plugin.getDataFolder(), "security"), "bugfix.reloading");
                        signalFile.createNewFile();
                    }
                    catch (IOException e) {
                        this.plugin.getLogger().log(Level.SEVERE, "[BugFixManager] Could not create reload signal file.", e);
                    }
                    break block9;
                }
                return;
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "[BugFixManager] Error during bug fix check: " + e.getMessage(), e);
            }
        }
    }

    private File downloadBugFix(String url, String version) throws IOException {
        this.plugin.getLogger().info("[BugFixManager] Downloading bug fix from NSR-AI update server: ");
        URL downloadUrl = new URL(url);
        String fileName = url.substring(url.lastIndexOf(47) + 1);
        File outputFile = new File(this.plugin.getDataFolder().getParentFile(), fileName);
        Files.copy(downloadUrl.openStream(), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        this.plugin.getLogger().info("[BugFixManager] Bug fix downloaded successfully to: " + outputFile.getAbsolutePath());
        return outputFile;
    }

    private int compareVersions(String v1, String v2) {
        String[] parts1 = v1.split("\\.");
        String[] parts2 = v2.split("\\.");
        int length = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < length; ++i) {
            int p2;
            int p1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int n = p2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
            if (p1 < p2) {
                return -1;
            }
            if (p1 <= p2) continue;
            return 1;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RemoteBugFixInfo getRemoteBugFixInfo(String pluginVersion) {
        try {
            Request request = new Request.Builder().url("https://nsr-ai-security.1987sakshamsingh.workers.dev/bugfix_version?plugin_version=" + pluginVersion).build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    this.plugin.getLogger().warning("[BugFixManager] Failed to fetch remote bug fix info from NSR-AI update server: " + response.code() + " " + response.message());
                    RemoteBugFixInfo remoteBugFixInfo = null;
                    return remoteBugFixInfo;
                }
                String responseBody = response.body().string();
                JsonObject jsonResponse = JsonParser.parseString(responseBody).getAsJsonObject();
                String version = jsonResponse.get("version").getAsString();
                String downloadUrl = jsonResponse.get("download_url").getAsString();
                boolean restartRequired = jsonResponse.has("restart_required") ? jsonResponse.get("restart_required").getAsBoolean() : false;
                RemoteBugFixInfo remoteBugFixInfo = new RemoteBugFixInfo(version, downloadUrl, restartRequired);
                return remoteBugFixInfo;
            }
        }
        catch (IOException | IllegalStateException e) {
            this.plugin.getLogger().log(Level.WARNING, "[BugFixManager] Error fetching remote bug fix info from NSR-AI update server", e);
            return null;
        }
    }

    public static class RemoteBugFixInfo {
        public String version;
        public String downloadUrl;
        public boolean restart_required;

        RemoteBugFixInfo(String version, String downloadUrl, boolean restart_required) {
            this.version = version;
            this.downloadUrl = downloadUrl;
            this.restart_required = restart_required;
        }
    }
}

