/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.managers;

import com.nsr.ai.plugin.ApiKeyManager;
import com.nsr.ai.plugin.NSRAIPlugin;
import com.nsr.ai.plugin.managers.PlayerApiKeyManager;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class OverloadedKeyManager {
    private final NSRAIPlugin plugin;
    private final Map<String, Long> globalKeyCooldowns = new ConcurrentHashMap<String, Long>();
    private final Map<UUID, Map<String, Long>> playerKeyCooldowns = new ConcurrentHashMap<UUID, Map<String, Long>>();
    private final long globalCooldownDuration;
    private final long playerCooldownDuration;

    public OverloadedKeyManager(NSRAIPlugin plugin, long globalCooldownDuration, long playerCooldownDuration) {
        this.plugin = plugin;
        this.globalCooldownDuration = globalCooldownDuration;
        this.playerCooldownDuration = playerCooldownDuration;
        this.startCleanupTask();
    }

    public void setOverloaded(ApiKeyManager.ApiKey key) {
        key.setStatus(ApiKeyManager.ApiKey.KeyStatus.LIMIT_REACHED);
        this.globalKeyCooldowns.put(key.getKey(), System.currentTimeMillis() + this.globalCooldownDuration);
        this.plugin.getLogger().warning("Global API key " + key.getKey() + " is now rate-limited for " + this.globalCooldownDuration / 1000L + " seconds.");
    }

    public void setOverloaded(PlayerApiKeyManager.ApiKey key) {
        key.setStatus(PlayerApiKeyManager.ApiKey.KeyStatus.LIMIT_REACHED);
        this.playerKeyCooldowns.computeIfAbsent(key.getPlayerUuid(), k -> new ConcurrentHashMap()).put(key.getKeyId(), System.currentTimeMillis() + this.playerCooldownDuration);
        this.plugin.getLogger().warning("Player API key " + key.getKeyId() + " for player " + String.valueOf(key.getPlayerUuid()) + " is now rate-limited for " + this.playerCooldownDuration / 1000L + " seconds.");
    }

    public boolean isOverloaded(ApiKeyManager.ApiKey key) {
        Long cooldownEndTime = this.globalKeyCooldowns.get(key.getKey());
        if (cooldownEndTime != null && System.currentTimeMillis() < cooldownEndTime) {
            return true;
        }
        if (cooldownEndTime != null && System.currentTimeMillis() >= cooldownEndTime) {
            this.globalKeyCooldowns.remove(key.getKey());
            key.setStatus(ApiKeyManager.ApiKey.KeyStatus.ACTIVE);
        }
        return false;
    }

    public boolean isOverloaded(PlayerApiKeyManager.ApiKey key) {
        Map<String, Long> playerSpecificCooldowns = this.playerKeyCooldowns.get(key.getPlayerUuid());
        if (playerSpecificCooldowns != null) {
            Long cooldownEndTime = playerSpecificCooldowns.get(key.getKeyId());
            if (cooldownEndTime != null && System.currentTimeMillis() < cooldownEndTime) {
                return true;
            }
            if (cooldownEndTime != null && System.currentTimeMillis() >= cooldownEndTime) {
                playerSpecificCooldowns.remove(key.getKeyId());
                key.setStatus(PlayerApiKeyManager.ApiKey.KeyStatus.ACTIVE);
            }
        }
        return false;
    }

    private void startCleanupTask() {
        new BukkitRunnable(){

            public void run() {
                long currentTime = System.currentTimeMillis();
                OverloadedKeyManager.this.globalKeyCooldowns.entrySet().removeIf(entry -> currentTime >= (Long)entry.getValue());
                OverloadedKeyManager.this.playerKeyCooldowns.forEach((playerUuid, keyMap) -> keyMap.entrySet().removeIf(entry -> currentTime >= (Long)entry.getValue()));
                OverloadedKeyManager.this.playerKeyCooldowns.entrySet().removeIf(entry -> ((Map)entry.getValue()).isEmpty());
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 1200L, 1200L);
    }

    public boolean clearOverloadedStatus(UUID playerUuid, String keyId) {
        Map<String, Long> playerSpecificCooldowns = this.playerKeyCooldowns.get(playerUuid);
        if (playerSpecificCooldowns != null && playerSpecificCooldowns.remove(keyId) != null) {
            PlayerApiKeyManager.ApiKey key = this.plugin.getPlayerApiKeyManager().getKey(playerUuid, keyId);
            if (key != null) {
                key.setStatus(PlayerApiKeyManager.ApiKey.KeyStatus.ACTIVE);
            }
            return true;
        }
        return false;
    }

    public boolean clearGlobalOverloadedStatus(String keyString) {
        if (this.globalKeyCooldowns.remove(keyString) != null) {
            for (ApiKeyManager.ApiKey key : this.plugin.getApiKeyManager().getApiKeys()) {
                if (!key.getKey().equals(keyString)) continue;
                key.setStatus(ApiKeyManager.ApiKey.KeyStatus.ACTIVE);
                break;
            }
            return true;
        }
        return false;
    }
}

