/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.managers;

import com.nsr.ai.plugin.NSRAIPlugin;
import com.nsr.ai.plugin.managers.ApiKeyStorage;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class PlayerApiKeyManager {
    private final NSRAIPlugin plugin;
    private final Map<UUID, Map<String, ApiKey>> playerApiKeys = new ConcurrentHashMap<UUID, Map<String, ApiKey>>();
    private final Map<UUID, Boolean> playerFallback = new ConcurrentHashMap<UUID, Boolean>();
    private final ApiKeyStorage apiKeyStorage;
    private final Map<UUID, Integer> playerKeyIndex = new ConcurrentHashMap<UUID, Integer>();

    public PlayerApiKeyManager(NSRAIPlugin plugin) {
        this.plugin = plugin;
        this.apiKeyStorage = new ApiKeyStorage(plugin);
    }

    public boolean isFallbackEnabled(UUID playerUuid) {
        return this.apiKeyStorage.loadPlayerFallbackSetting(playerUuid);
    }

    public void setFallbackEnabled(UUID playerUuid, boolean enabled) {
        this.playerFallback.put(playerUuid, enabled);
        this.apiKeyStorage.savePlayerSettings(playerUuid, enabled);
    }

    public ApiKey addSessionKey(Player player, String apiKey) {
        if (apiKey.toLowerCase().startsWith("store-")) {
            return null;
        }
        ApiKey newKey = this.createBaseApiKey(player, apiKey);
        newKey.setKeyId("#" + this.generateAlphanumeric(6));
        newKey.setStorageMode(ApiKey.StorageMode.SESSION);
        newKey.setProjectId(null);
        Map playerKeys = this.playerApiKeys.computeIfAbsent(player.getUniqueId(), k -> new ConcurrentHashMap());
        playerKeys.put(newKey.getKeyId(), newKey);
        return newKey;
    }

    public ApiKey addStoredKey(Player player, String apiKey, String projectId) {
        ApiKey newKey = this.createBaseApiKey(player, apiKey);
        newKey.setKeyId(projectId);
        newKey.setStorageMode(ApiKey.StorageMode.STORED);
        newKey.setProjectId(projectId);
        Map playerKeys = this.playerApiKeys.computeIfAbsent(player.getUniqueId(), k -> new ConcurrentHashMap());
        playerKeys.put(newKey.getKeyId(), newKey);
        this.apiKeyStorage.saveKey(newKey);
        return newKey;
    }

    public ApiKey getKey(Player player, String keyId) {
        return this.getPlayerKeys(player.getUniqueId()).get(keyId);
    }

    public ApiKey getKey(UUID playerUuid, String keyId) {
        return this.getPlayerKeys(playerUuid).get(keyId);
    }

    public Collection<ApiKey> getAllKeys(Player player) {
        return this.getPlayerKeys(player.getUniqueId()).values();
    }

    public Collection<ApiKey> getAllKeys(UUID playerUuid) {
        return this.getPlayerKeys(playerUuid).values();
    }

    public Set<UUID> getAllPlayerUUIDs() {
        return this.playerApiKeys.keySet();
    }

    public ApiKey deleteKey(Player player, String keyId) {
        ApiKey removedKey = this.getPlayerKeys(player.getUniqueId()).remove(keyId);
        if (removedKey != null && removedKey.getStorageMode() == ApiKey.StorageMode.STORED) {
            this.apiKeyStorage.deleteKey(player.getUniqueId(), removedKey.getProjectId());
        }
        return removedKey;
    }

    public int deleteAllKeys(Player player) {
        Map<String, ApiKey> playerKeys = this.getPlayerKeys(player.getUniqueId());
        int count = playerKeys.size();
        for (ApiKey key : playerKeys.values()) {
            if (key.getStorageMode() != ApiKey.StorageMode.STORED) continue;
            this.apiKeyStorage.deleteKey(player.getUniqueId(), key.getProjectId());
        }
        playerKeys.clear();
        return count;
    }

    public ApiKey updateModel(Player player, String keyId, String newModel) {
        ApiKey key = this.getKey(player, keyId);
        if (key != null) {
            key.setModel(newModel);
            if (key.getStorageMode() == ApiKey.StorageMode.STORED) {
                this.apiKeyStorage.saveKey(key);
            }
        }
        return key;
    }

    public ApiKey getNextRotatedApiKey(UUID playerUuid) {
        Map<String, ApiKey> playerKeys = this.getPlayerKeys(playerUuid);
        if (playerKeys.isEmpty()) {
            return null;
        }
        ArrayList<ApiKey> keyList = new ArrayList<ApiKey>(playerKeys.values());
        int lastIndex = this.playerKeyIndex.getOrDefault(playerUuid, -1);
        int nextIndex = (lastIndex + 1) % keyList.size();
        this.playerKeyIndex.put(playerUuid, nextIndex);
        return (ApiKey)keyList.get(nextIndex);
    }

    public void setAllKeysStatus(UUID playerUuid, ApiKey.KeyStatus status, ApiKey exception) {
        for (ApiKey key : this.getPlayerKeys(playerUuid).values()) {
            if (key == exception) continue;
            key.setStatus(status);
        }
    }

    public List<ApiKey> getActiveApiKeys(UUID playerUuid) {
        return this.getPlayerKeys(playerUuid).values().stream().filter(k -> k.getStatus() != ApiKey.KeyStatus.INACTIVE && k.getStatus() != ApiKey.KeyStatus.LIMIT_REACHED).collect(Collectors.toList());
    }

    private Map<String, ApiKey> getPlayerKeys(UUID playerUuid) {
        return this.playerApiKeys.computeIfAbsent(playerUuid, k -> {
            ConcurrentHashMap<String, ApiKey> loadedKeys = new ConcurrentHashMap<String, ApiKey>();
            this.apiKeyStorage.loadKeysForPlayer((UUID)k, (Map<String, ApiKey>)loadedKeys);
            return loadedKeys;
        });
    }

    private ApiKey createBaseApiKey(Player player, String apiKey) {
        ApiKey newKey = new ApiKey();
        newKey.setPlayerUuid(player.getUniqueId());
        newKey.setApiKey(apiKey);
        newKey.setMaskedKey(this.maskApiKey(apiKey));
        newKey.setCreationDate(System.currentTimeMillis());
        newKey.setStatus(ApiKey.KeyStatus.ACTIVE);
        newKey.setSaveChatHistory(false);
        this.detectProviderAndModel(newKey);
        return newKey;
    }

    void detectProviderAndModel(ApiKey apiKey) {
        String key = apiKey.getApiKey();
        if (key.startsWith("AIza")) {
            apiKey.setProvider(ApiKey.Provider.GOOGLE);
            if (apiKey.getModel() == null || apiKey.getModel().isEmpty()) {
                apiKey.setModel("gemini-2.0-flash");
            }
        } else if (key.startsWith("sk-ant-")) {
            apiKey.setProvider(ApiKey.Provider.ANTHROPIC);
            if (apiKey.getModel() == null || apiKey.getModel().isEmpty()) {
                apiKey.setModel("claude-3-haiku-20240307");
            }
        } else if (key.startsWith("sk-")) {
            apiKey.setProvider(ApiKey.Provider.OPENAI);
            if (apiKey.getModel() == null || apiKey.getModel().isEmpty()) {
                apiKey.setModel("gpt-4o");
            }
        } else {
            apiKey.setProvider(ApiKey.Provider.UNKNOWN);
            if (apiKey.getModel() == null || apiKey.getModel().isEmpty()) {
                apiKey.setModel("unknown");
            }
        }
        if (apiKey.getProvider() == ApiKey.Provider.UNKNOWN || apiKey.getModel().equalsIgnoreCase("unknown") || apiKey.getModel().equalsIgnoreCase("all")) {
            apiKey.setStatus(ApiKey.KeyStatus.INVALID);
        }
    }

    String maskApiKey(String apiKey) {
        if (apiKey.length() > 7) {
            return apiKey.substring(0, 4) + "***" + apiKey.substring(apiKey.length() - 4);
        }
        return "***";
    }

    private String generateAlphanumeric(int length) {
        String CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        SecureRandom random = new SecureRandom();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(CHARS.charAt(random.nextInt(CHARS.length())));
        }
        return sb.toString();
    }

    public boolean hasApiKeys(UUID playerUuid) {
        return this.playerApiKeys.containsKey(playerUuid) && !this.playerApiKeys.get(playerUuid).isEmpty();
    }

    public String getNextApiKey(UUID playerUuid) {
        Map<String, ApiKey> playerKeys = this.getPlayerKeys(playerUuid);
        if (playerKeys.isEmpty()) {
            return null;
        }
        return playerKeys.values().iterator().next().getApiKey();
    }

    public void clearApiKeys(UUID playerUuid) {
        this.playerApiKeys.remove(playerUuid);
    }

    public void setSaveChatHistory(UUID playerUuid, String keyId, boolean saveChatHistory) {
        ApiKey key = this.getKey(playerUuid, keyId);
        if (key != null) {
            key.setSaveChatHistory(saveChatHistory);
            if (key.getStorageMode() == ApiKey.StorageMode.STORED) {
                this.apiKeyStorage.saveKey(key);
            }
        }
    }

    public void onPlayerDisconnect(UUID playerUuid) {
        this.playerApiKeys.remove(playerUuid);
    }

    public ApiKey getMostRecentSessionKey(UUID playerUuid) {
        return this.getPlayerKeys(playerUuid).values().stream().filter(key -> key.getStorageMode() == ApiKey.StorageMode.SESSION).max((k1, k2) -> Long.compare(k1.getCreationDate(), k2.getCreationDate())).orElse(null);
    }

    public ApiKey getActiveKey(UUID playerUuid) {
        return this.getPlayerKeys(playerUuid).values().stream().max((k1, k2) -> Long.compare(k1.getCreationDate(), k2.getCreationDate())).orElse(null);
    }

    public ApiKey getKeyByString(String apiKey) {
        for (Map<String, ApiKey> playerKeys : this.playerApiKeys.values()) {
            for (ApiKey key : playerKeys.values()) {
                if (!key.getApiKey().equals(apiKey)) continue;
                return key;
            }
        }
        return null;
    }

    public ApiKey convertSessionKeyToStored(UUID playerUuid, String sessionKeyId, String projectId) {
        Map<String, ApiKey> playerKeys = this.getPlayerKeys(playerUuid);
        ApiKey sessionKey = playerKeys.get(sessionKeyId);
        if (sessionKey != null && sessionKey.getStorageMode() == ApiKey.StorageMode.SESSION) {
            playerKeys.remove(sessionKeyId);
            ApiKey storedKey = new ApiKey();
            storedKey.setPlayerUuid(playerUuid);
            storedKey.setApiKey(sessionKey.getApiKey());
            storedKey.setMaskedKey(sessionKey.getMaskedKey());
            storedKey.setCreationDate(sessionKey.getCreationDate());
            storedKey.setStatus(sessionKey.getStatus());
            storedKey.setProvider(sessionKey.getProvider());
            storedKey.setModel(sessionKey.getModel());
            storedKey.setUsageCount(sessionKey.getUsageCount());
            storedKey.setErrorCount(sessionKey.getErrorCount());
            storedKey.setFallbackCount(sessionKey.getFallbackCount());
            storedKey.setSaveChatHistory(sessionKey.isSaveChatHistory());
            storedKey.setKeyId(projectId);
            storedKey.setStorageMode(ApiKey.StorageMode.STORED);
            storedKey.setProjectId(projectId);
            playerKeys.put(storedKey.getKeyId(), storedKey);
            this.apiKeyStorage.saveKey(storedKey);
            return storedKey;
        }
        return null;
    }

    public static class ApiKey {
        private String keyId;
        private String apiKey;
        private String maskedKey;
        private Provider provider;
        private String model;
        private KeyStatus status;
        private StorageMode storageMode;
        private long creationDate;
        private int usageCount;
        private int errorCount;
        private int fallbackCount;
        private String projectId;
        private UUID playerUuid;
        private boolean saveChatHistory;

        public String getKeyId() {
            return this.keyId;
        }

        public void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public String getApiKey() {
            return this.apiKey;
        }

        public void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        public String getMaskedKey() {
            return this.maskedKey;
        }

        public void setMaskedKey(String maskedKey) {
            this.maskedKey = maskedKey;
        }

        public Provider getProvider() {
            return this.provider;
        }

        public void setProvider(Provider provider) {
            this.provider = provider;
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public KeyStatus getStatus() {
            return this.status;
        }

        public void setStatus(KeyStatus status) {
            this.status = status;
        }

        public StorageMode getStorageMode() {
            return this.storageMode;
        }

        public void setStorageMode(StorageMode storageMode) {
            this.storageMode = storageMode;
        }

        public long getCreationDate() {
            return this.creationDate;
        }

        public void setCreationDate(long creationDate) {
            this.creationDate = creationDate;
        }

        public int getUsageCount() {
            return this.usageCount;
        }

        public void setUsageCount(int usageCount) {
            this.usageCount = usageCount;
        }

        public int getErrorCount() {
            return this.errorCount;
        }

        public void setErrorCount(int errorCount) {
            this.errorCount = errorCount;
        }

        public int getFallbackCount() {
            return this.fallbackCount;
        }

        public void setFallbackCount(int fallbackCount) {
            this.fallbackCount = fallbackCount;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public UUID getPlayerUuid() {
            return this.playerUuid;
        }

        public void setPlayerUuid(UUID playerUuid) {
            this.playerUuid = playerUuid;
        }

        public boolean isSaveChatHistory() {
            return this.saveChatHistory;
        }

        public void setSaveChatHistory(boolean saveChatHistory) {
            this.saveChatHistory = saveChatHistory;
        }

        public void incrementUsageCount() {
            ++this.usageCount;
            if (this.storageMode == StorageMode.STORED) {
                NSRAIPlugin.getInstance().getApiKeyStorage().saveKey(this);
            }
        }

        public void incrementErrorCount() {
            ++this.errorCount;
            if (this.storageMode == StorageMode.STORED) {
                NSRAIPlugin.getInstance().getApiKeyStorage().saveKey(this);
            }
        }

        public void incrementFallbackCount() {
            ++this.fallbackCount;
            if (this.storageMode == StorageMode.STORED) {
                NSRAIPlugin.getInstance().getApiKeyStorage().saveKey(this);
            }
        }

        public static enum Provider {
            GOOGLE,
            ANTHROPIC,
            OPENAI,
            UNKNOWN;

        }

        public static enum KeyStatus {
            ACTIVE,
            INACTIVE,
            USING,
            OVERLOADED,
            LIMIT_REACHED,
            INVALID;

        }

        public static enum StorageMode {
            SESSION,
            STORED;

        }
    }
}

