/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.managers;

import com.nsr.ai.plugin.NSRAIPlugin;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class PlayerSecurityManager {
    private final NSRAIPlugin plugin;
    private final File playerKeysBaseDir;
    private final ConcurrentHashMap<UUID, SecretKey> keyCache = new ConcurrentHashMap();

    public PlayerSecurityManager(NSRAIPlugin plugin) {
        this.plugin = plugin;
        this.playerKeysBaseDir = new File(plugin.getDataFolder(), "player_keys");
        if (!this.playerKeysBaseDir.exists()) {
            this.playerKeysBaseDir.mkdirs();
        }
    }

    public SecretKey getPlayerMasterKey(UUID playerUuid) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        SecretKey masterKey;
        File playerMasterKeyFile;
        if (this.keyCache.containsKey(playerUuid)) {
            return this.keyCache.get(playerUuid);
        }
        File playerDir = new File(this.playerKeysBaseDir, playerUuid.toString());
        if (!playerDir.exists()) {
            playerDir.mkdirs();
        }
        if ((playerMasterKeyFile = new File(playerDir, "master.key")).exists()) {
            byte[] keyBytes = Files.readAllBytes(playerMasterKeyFile.toPath());
            masterKey = new SecretKeySpec(keyBytes, "AES");
        } else {
            this.plugin.getLogger().info("[NSR-AI Security] Generating new master key for player " + String.valueOf(playerUuid));
            byte[] salt = this.getOrCreatePlayerSalt(playerDir);
            byte[] secret = this.plugin.getSecurityUtil().generateRandomBytes(32);
            masterKey = this.plugin.getSecurityUtil().generateMasterKey(secret, salt);
            Files.write(playerMasterKeyFile.toPath(), masterKey.getEncoded(), new OpenOption[0]);
        }
        this.keyCache.put(playerUuid, masterKey);
        return masterKey;
    }

    public byte[] getOrCreatePlayerSalt(File playerDir) throws IOException {
        byte[] salt;
        File saltFile = new File(playerDir, "salt.bin");
        if (saltFile.exists()) {
            salt = Files.readAllBytes(saltFile.toPath());
        } else {
            salt = this.plugin.getSecurityUtil().generateRandomBytes(16);
            Files.write(saltFile.toPath(), salt, new OpenOption[0]);
        }
        return salt;
    }

    public void clearCache(UUID playerUuid) {
        this.keyCache.remove(playerUuid);
    }
}

