/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.pet;

import com.nsr.ai.plugin.NSRAIPlugin;
import com.nsr.ai.plugin.pet.Pet;
import com.nsr.ai.plugin.pet.PetManager;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;

public class PetCommand
implements CommandExecutor {
    private final NSRAIPlugin plugin;
    private final PetManager petManager;
    private static final List<String> SPECIAL_TAME_TYPES = Arrays.asList("PANDA", "PIG", "COW", "SHEEP");

    public PetCommand(NSRAIPlugin plugin, PetManager petManager) {
        this.plugin = plugin;
        this.petManager = petManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (args2.length < 1) {
            this.sendUsage(player);
            return true;
        }
        String subCommand = args2[0].toLowerCase();
        if (args2.length > 1) {
            subCommand = args2[1].toLowerCase();
        }
        switch (subCommand) {
            case "tame": {
                this.handleTameCommand(player);
                break;
            }
            case "nickname": {
                if (args2.length < 3) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai pet nickname <nickname>");
                    return true;
                }
                this.handleNicknameCommand(player, args2[2]);
                break;
            }
            case "list": {
                this.handleListCommand(player);
                break;
            }
            case "info": {
                if (args2.length < 3) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai pet info <pet_name>");
                    return true;
                }
                this.handleInfoCommand(player, args2[2]);
                break;
            }
            case "inv": {
                if (args2.length < 3) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ai pet inv <pet_name>");
                    return true;
                }
                this.handleInvCommand(player, args2[2]);
                break;
            }
            default: {
                this.sendUsage(player);
            }
        }
        return true;
    }

    private void handleTameCommand(Player player) {
        Entity targetEntity = this.getTargetEntity(player, 10);
        if (targetEntity == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You must be looking at a pet or animal to tame.");
            return;
        }
        EntityType entityType = targetEntity.getType();
        String entityTypeName = entityType.name();
        if (entityTypeName.equals("RABBIT") || entityTypeName.equals("TURTLE") || entityTypeName.equals("FOX")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This pet or animal type cannot be tamed as an AI pet.");
            return;
        }
        String petName = targetEntity.getCustomName();
        if (SPECIAL_TAME_TYPES.contains(entityTypeName)) {
            if (petName == null || petName.isEmpty()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "This pet or animal needs a name! Please name it with a nametag first.");
                return;
            }
        } else if (targetEntity instanceof Tameable) {
            Tameable tameable = (Tameable)targetEntity;
            if (!tameable.isTamed() || tameable.getOwner() == null || !tameable.getOwner().getUniqueId().equals(player.getUniqueId())) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You can only link pets that you own and have tamed.");
                return;
            }
            if (petName == null || petName.isEmpty()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Your tamed pet needs a name! Please name it with a nametag first.");
                return;
            }
        } else {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This pet or animal type cannot be tamed as an AI pet.");
            return;
        }
        if (this.plugin.getReservedNicknameManager().isNicknameReserved(petName)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This pet name is already in use by another player's pet. Please choose a different name.");
            return;
        }
        if (this.petManager.getPet(player, petName) != null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This pet is already linked to the AI.");
            return;
        }
        Pet newPet = new Pet(petName, entityType, player.getName(), player.getUniqueId());
        newPet.setTamedDate(null);
        this.petManager.linkPet(newPet);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your pet \"" + petName + "\" is now linked to the AI! You can talk to it now.");
    }

    private void handleNicknameCommand(Player player, String nickname) {
        String oldNickname;
        Entity targetEntity = this.getTargetEntity(player, 10);
        if (targetEntity == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You must be looking at a linked pet.");
            return;
        }
        if (targetEntity.getCustomName() == null || targetEntity.getCustomName().isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This pet is not linked to the AI.");
            return;
        }
        String petName = targetEntity.getCustomName();
        Pet pet = this.petManager.getPet(player, petName);
        if (pet == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This pet is not linked to the AI.");
            return;
        }
        if (this.plugin.getReservedNicknameManager().isNicknameReserved(nickname) && !this.plugin.getReservedNicknameManager().getReservedNicknameOwner(nickname).equals(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "That nickname is reserved.");
            return;
        }
        Map<String, Pet> playerPets = this.petManager.getLoadedPets().get(player.getUniqueId());
        if (playerPets != null) {
            for (Pet otherPet : playerPets.values()) {
                if (otherPet == pet || !nickname.equalsIgnoreCase(otherPet.getNickname())) continue;
                player.sendMessage(String.valueOf(ChatColor.RED) + "You already have another pet with that nickname.");
                return;
            }
        }
        if ((oldNickname = pet.getNickname()) != null && !oldNickname.isEmpty()) {
            this.plugin.getReservedNicknameManager().releaseNickname(oldNickname);
        }
        pet.setNickname(nickname);
        this.plugin.getReservedNicknameManager().reserveNickname(nickname, player.getUniqueId());
        this.petManager.savePet(pet);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Pet \"" + pet.getPetName() + "\" is now nicknamed \"" + nickname + "\". \ud83d\udc3e");
    }

    private void handleListCommand(Player player) {
        Map<String, Pet> playerPets = this.petManager.getLoadedPets().get(player.getUniqueId());
        if (playerPets == null || playerPets.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "You have no linked pets.");
            return;
        }
        player.sendMessage(String.valueOf(ChatColor.AQUA) + "--- Your Pets ---");
        for (Pet pet : playerPets.values()) {
            String status = pet.getStatus().equalsIgnoreCase("dead") ? "&c(Dead)" : "&a(Alive)";
            player.sendMessage(this.plugin.colorize("&e- " + pet.getPetName() + (String)(pet.getNickname() != null ? " (&7" + pet.getNickname() + "&e)" : "") + " " + status));
        }
    }

    private void handleInfoCommand(Player player, String petName) {
        Pet pet = this.petManager.getPet(player, petName);
        if (pet == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have a pet with that name.");
            return;
        }
        player.sendMessage(String.valueOf(ChatColor.AQUA) + "--- Pet Stats: " + pet.getPetName() + " ---");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Nickname: " + (pet.getNickname() != null ? pet.getNickname() : "N/A"));
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Level: " + String.valueOf(ChatColor.WHITE) + pet.getLevel() + " (" + pet.getXp() + " XP)");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Health: " + String.valueOf(ChatColor.WHITE) + pet.getHealth());
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Hunger: " + String.valueOf(ChatColor.WHITE) + pet.getHunger());
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Mood: " + String.valueOf(ChatColor.WHITE) + pet.getMood().name());
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Bond: " + String.valueOf(ChatColor.WHITE) + pet.getBond());
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Status: " + String.valueOf(ChatColor.WHITE) + pet.getStatus());
    }

    private void handleInvCommand(Player player, String petName) {
        Pet pet = this.petManager.getPet(player, petName);
        if (pet == null) {
            boolean allowed = false;
            for (Map<String, Pet> ownerPetsMap : this.petManager.getLoadedPets().values()) {
                for (Pet otherPet : ownerPetsMap.values()) {
                    if (!otherPet.getPetName().equalsIgnoreCase(petName) || !this.petManager.hasInventoryAccess(otherPet, player.getUniqueId())) continue;
                    pet = otherPet;
                    allowed = true;
                    break;
                }
                if (!allowed) continue;
                break;
            }
            if (!allowed || pet == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have a pet with that name or permission to access its inventory.");
                return;
            }
        }
        this.petManager.openPetInventory(player, pet);
    }

    public void sendUsage(Player player) {
        player.sendMessage(String.valueOf(ChatColor.AQUA) + "--- Pet AI Commands ---");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ai pet tame" + String.valueOf(ChatColor.GRAY) + " - Link a pet or animal to the AI. For tameable animals (e.g., Wolf), they must be tamed and owned by you. For others (e.g., Pig, Cow), they must have a nametag.");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ai pet nickname <nickname>" + String.valueOf(ChatColor.GRAY) + " - Give your linked pet a nickname (must be looking at your pet).");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ai pet list" + String.valueOf(ChatColor.GRAY) + " - List all your linked pets.");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ai pet info <pet_name>" + String.valueOf(ChatColor.GRAY) + " - Get info about a specific pet.");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ai pet inv <pet_name>" + String.valueOf(ChatColor.GRAY) + " - Open a specific pet's inventory.");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ai pet share <pet_name> [allow] [relationship]" + String.valueOf(ChatColor.GRAY) + " - Generate a share link for your pet.");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ai pet <link_code>" + String.valueOf(ChatColor.GRAY) + " - Use a pet share link.");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ai pet removefriend <player_name> <pet_name>" + String.valueOf(ChatColor.GRAY) + " - Remove a player from your pet's friends.");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ai pet relation <pet_name> <player_name> <new_relationship>" + String.valueOf(ChatColor.GRAY) + " - Change a player's relationship with your pet.");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ai pet link list" + String.valueOf(ChatColor.GRAY) + " - List pets you have shared with others.");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ai pet linked list" + String.valueOf(ChatColor.GRAY) + " - List pets you are linked with.");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ai pet unlink <pet_name>" + String.valueOf(ChatColor.GRAY) + " - Unlink from a pet.");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/ai pet inv allow <pet_name> <player_name>" + String.valueOf(ChatColor.GRAY) + " - Allow a player to access your pet's inventory.");
    }

    private Entity getTargetEntity(Player player, int range) {
        return player.getNearbyEntities((double)range, (double)range, (double)range).stream().filter(entity -> {
            if (entity instanceof Player) {
                return false;
            }
            return player.hasLineOfSight(entity);
        }).min((e1, e2) -> Double.compare(e1.getLocation().distanceSquared(player.getEyeLocation()), e2.getLocation().distanceSquared(player.getEyeLocation()))).orElse(null);
    }
}

