/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.pet;

import com.nsr.ai.plugin.NSRAIPlugin;
import com.nsr.ai.plugin.pet.Pet;
import com.nsr.ai.plugin.pet.ReservedNicknameManager;
import com.nsr.ai.plugin.pet.data.PetDataStorage;
import com.nsr.ai.plugin.pet.data.PetFriendData;
import com.nsr.ai.plugin.pet.data.SharedPetLink;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PetManager {
    private final NSRAIPlugin plugin;
    private final PetDataStorage petDataStorage;
    private final Map<UUID, Map<String, Pet>> loadedPets = new HashMap<UUID, Map<String, Pet>>();
    private final Map<String, SharedPetLink> activeLinks = new HashMap<String, SharedPetLink>();
    private final ReservedNicknameManager reservedNicknameManager;

    public PetManager(NSRAIPlugin plugin) {
        this.plugin = plugin;
        this.petDataStorage = new PetDataStorage(plugin);
        this.reservedNicknameManager = plugin.getReservedNicknameManager();
        this.startLinkCleanupTask();
    }

    private void startLinkCleanupTask() {
        new BukkitRunnable(){

            public void run() {
                Iterator<Map.Entry<String, SharedPetLink>> iterator2 = PetManager.this.activeLinks.entrySet().iterator();
                while (iterator2.hasNext()) {
                    SharedPetLink link = iterator2.next().getValue();
                    if (!link.isExpired()) continue;
                    iterator2.remove();
                    PetManager.this.plugin.getLogger().info("Expired pet share link removed: " + link.getLinkCode());
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1200L, 1200L);
    }

    public Map<UUID, Map<String, Pet>> getLoadedPets() {
        return this.loadedPets;
    }

    public void loadPetsForPlayer(Player player) {
        File playerPetFolder = new File(this.plugin.getDataFolder(), "pets" + File.separator + player.getName());
        if (!playerPetFolder.exists()) {
            return;
        }
        HashMap<String, Pet> playerPets = new HashMap<String, Pet>();
        for (File petFolder : playerPetFolder.listFiles()) {
            Pet pet;
            if (!petFolder.isDirectory() || (pet = this.petDataStorage.loadPet(player.getName(), petFolder.getName())) == null) continue;
            playerPets.put(pet.getPetName(), pet);
        }
        this.loadedPets.put(player.getUniqueId(), playerPets);
    }

    public void unloadPetsForPlayer(Player player) {
        this.loadedPets.remove(player.getUniqueId());
    }

    public Pet getPet(Player owner, String petName) {
        Map<String, Pet> playerPets = this.loadedPets.get(owner.getUniqueId());
        if (playerPets != null) {
            return playerPets.get(petName);
        }
        return null;
    }

    public Pet findPetByName(String petName) {
        for (Map<String, Pet> playerPets : this.loadedPets.values()) {
            for (Pet pet : playerPets.values()) {
                if (!pet.getPetName().equalsIgnoreCase(petName)) continue;
                return pet;
            }
        }
        return null;
    }

    public void linkPet(Pet pet) {
        Map playerPets = this.loadedPets.computeIfAbsent(pet.getOwnerUuid(), k -> new HashMap());
        playerPets.put(pet.getPetName(), pet);
        this.plugin.getReservedNicknameManager().reserveNickname(pet.getPetName(), pet.getOwnerUuid());
        this.petDataStorage.savePet(pet);
    }

    public void savePet(Pet pet) {
        this.petDataStorage.savePet(pet);
    }

    public void loadAllPets() {
        File petsFolder = new File(this.plugin.getDataFolder(), "pets");
        if (!petsFolder.exists()) {
            return;
        }
        for (File playerFolder : petsFolder.listFiles()) {
            if (!playerFolder.isDirectory()) continue;
            String ownerName = playerFolder.getName();
            for (File petFolder : playerFolder.listFiles()) {
                Pet pet;
                if (!petFolder.isDirectory() || (pet = this.petDataStorage.loadPet(ownerName, petFolder.getName())) == null || pet.getStatus().equalsIgnoreCase("dead")) continue;
                this.loadedPets.computeIfAbsent(pet.getOwnerUuid(), k -> new HashMap()).put(pet.getPetName(), pet);
            }
        }
        this.plugin.getLogger().info("Loaded " + this.loadedPets.size() + " pets from disk.");
    }

    public PetDataStorage getPetDataStorage() {
        return this.petDataStorage;
    }

    public Pet findPetByFriendAndName(UUID friendUUID, String petName) {
        File petsFolder = new File(this.plugin.getDataFolder(), "pets");
        if (!petsFolder.exists()) {
            return null;
        }
        for (File playerFolder : petsFolder.listFiles()) {
            if (!playerFolder.isDirectory()) continue;
            String ownerName = playerFolder.getName();
            for (File petFolder : playerFolder.listFiles()) {
                Pet pet;
                if (!petFolder.isDirectory() || (pet = this.petDataStorage.loadPet(ownerName, petFolder.getName())) == null || !pet.getPetName().equalsIgnoreCase(petName) || !pet.getPetFriends().containsKey(friendUUID)) continue;
                return pet;
            }
        }
        return null;
    }

    public void removePetFromMemory(UUID ownerUuid, String petName) {
        Map<String, Pet> playerPets = this.loadedPets.get(ownerUuid);
        if (playerPets != null) {
            playerPets.remove(petName);
            if (playerPets.isEmpty()) {
                this.loadedPets.remove(ownerUuid);
            }
        }
    }

    public void openPetInventory(Player player, Pet pet) {
        if (pet.getInventory() == null) {
            Inventory inv = Bukkit.createInventory(null, (int)9, (String)(pet.getPetName() + "'s Inventory"));
            pet.setInventory(inv);
        }
        player.openInventory(pet.getInventory());
    }

    public void allowInventoryAccess(Pet pet, UUID playerUUID) {
        pet.getAllowedInventoryAccess().add(playerUUID);
        this.savePet(pet);
    }

    public void removeInventoryAccess(Pet pet, UUID playerUUID) {
        pet.getAllowedInventoryAccess().remove(playerUUID);
        this.savePet(pet);
    }

    public boolean hasInventoryAccess(Pet pet, UUID playerUUID) {
        return pet.getAllowedInventoryAccess().contains(playerUUID);
    }

    public boolean canInteract(Pet pet, UUID playerUUID) {
        if (pet == null || playerUUID == null) {
            return false;
        }
        return pet.getOwnerUuid().equals(playerUUID) || pet.getPetFriends().containsKey(playerUUID);
    }

    public void addPetFriend(Pet pet, UUID friendUUID, String relationship) {
        pet.getPetFriends().put(friendUUID, new PetFriendData(friendUUID, relationship, System.currentTimeMillis()));
        this.savePet(pet);
    }

    public void removePetFriend(Pet pet, UUID friendUUID) {
        pet.getPetFriends().remove(friendUUID);
        this.savePet(pet);
    }

    public PetFriendData getPetFriendData(Pet pet, UUID friendUUID) {
        return pet.getPetFriends().get(friendUUID);
    }

    public Map<String, SharedPetLink> getActiveLinks() {
        return this.activeLinks;
    }

    public String generateShareLink(Pet pet, UUID originatorUUID, boolean requiresAcceptance, String requestedRelationship) {
        String linkCode = this.generateUniqueLinkCode();
        long expirationTime = System.currentTimeMillis() + 600000L;
        SharedPetLink link = new SharedPetLink(linkCode, pet.getPetName(), pet.getOwnerUuid(), null, expirationTime, requiresAcceptance, requestedRelationship, originatorUUID);
        this.activeLinks.put(linkCode, link);
        return linkCode;
    }

    private String generateUniqueLinkCode() {
        String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < 6; ++i) {
            sb.append(chars.charAt(random.nextInt(chars.length())));
        }
        String linkCode = sb.toString().toLowerCase();
        if (this.activeLinks.containsKey(linkCode)) {
            return this.generateUniqueLinkCode();
        }
        return linkCode;
    }
}

