/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.pet;

import com.nsr.ai.plugin.NSRAIPlugin;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ReservedNicknameManager {
    private final NSRAIPlugin plugin;
    private File reservedNicknamesFile;
    private FileConfiguration reservedNicknamesConfig;

    public ReservedNicknameManager(NSRAIPlugin plugin) {
        this.plugin = plugin;
        File petsFolder = new File(plugin.getDataFolder(), "pets");
        if (!petsFolder.exists()) {
            petsFolder.mkdirs();
        }
        this.reservedNicknamesFile = new File(petsFolder, "reserved_nicknames.yml");
        if (!this.reservedNicknamesFile.exists()) {
            try {
                this.reservedNicknamesFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.reservedNicknamesConfig = YamlConfiguration.loadConfiguration((File)this.reservedNicknamesFile);
    }

    public void reserveNickname(String nickname, UUID ownerUuid) {
        this.reservedNicknamesConfig.set(nickname.toLowerCase(), (Object)ownerUuid.toString());
        this.saveConfig();
    }

    public void releaseNickname(String nickname) {
        this.reservedNicknamesConfig.set(nickname.toLowerCase(), null);
        this.saveConfig();
    }

    public boolean isNicknameReserved(String nickname) {
        return this.reservedNicknamesConfig.isSet(nickname.toLowerCase());
    }

    public UUID getReservedNicknameOwner(String nickname) {
        return UUID.fromString(this.reservedNicknamesConfig.getString(nickname.toLowerCase()));
    }

    private void saveConfig() {
        try {
            this.reservedNicknamesConfig.save(this.reservedNicknamesFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

