/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.plugin.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nsr.ai.plugin.NSRAIPlugin;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    private final NSRAIPlugin plugin;
    private final String currentVersion;
    private final String updateUrl;
    private String latestVersion;
    private List<String> latestFeatures;
    private final Gson gson = new Gson();

    public UpdateChecker(NSRAIPlugin plugin, String updateUrl) {
        this.plugin = plugin;
        this.currentVersion = plugin.getDescription().getVersion();
        this.updateUrl = updateUrl;
    }

    public void checkForUpdates() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL(this.updateUrl).openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    String inputLine;
                    BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder content = new StringBuilder();
                    while ((inputLine = in.readLine()) != null) {
                        content.append(inputLine);
                    }
                    in.close();
                    connection.disconnect();
                    JsonObject jsonResponse = JsonParser.parseString(content.toString()).getAsJsonObject();
                    this.latestVersion = jsonResponse.get("version").getAsString();
                    JsonArray featuresArray = jsonResponse.getAsJsonArray("features");
                    this.latestFeatures = new ArrayList<String>();
                    if (featuresArray != null) {
                        for (int i = 0; i < featuresArray.size(); ++i) {
                            this.latestFeatures.add(featuresArray.get(i).getAsString());
                        }
                    }
                } else {
                    this.plugin.getLogger().warning("UpdateChecker: Failed to fetch update. HTTP response code: " + responseCode);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "UpdateChecker: Could not check for updates: " + e.getMessage(), e);
            }
        });
    }

    public boolean isOutdated() {
        if (this.latestVersion == null || this.latestVersion.isEmpty()) {
            return false;
        }
        try {
            String[] currentParts = this.currentVersion.split("\\.");
            String[] latestParts = this.latestVersion.split("\\.");
            int length = Math.max(currentParts.length, latestParts.length);
            for (int i = 0; i < length; ++i) {
                int latest;
                int current = i < currentParts.length ? Integer.parseInt(currentParts[i].replaceAll("[^\\d]", "")) : 0;
                int n = latest = i < latestParts.length ? Integer.parseInt(latestParts[i].replaceAll("[^\\d]", "")) : 0;
                if (latest > current) {
                    return true;
                }
                if (latest >= current) continue;
                return false;
            }
            return this.currentVersion.contains("-pre") && !this.latestVersion.contains("-pre");
        }
        catch (NumberFormatException e) {
            this.plugin.getLogger().warning("UpdateChecker: Error parsing version numbers: " + e.getMessage());
            return false;
        }
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public List<String> getLatestFeatures() {
        return this.latestFeatures;
    }
}

