/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.biomespawnpoint_common_forge.events;

import com.natamus.biomespawnpoint_common_forge.data.Constants;
import com.natamus.biomespawnpoint_common_forge.util.Util;
import com.natamus.collective_common_forge.functions.BlockPosFunctions;
import com.natamus.collective_common_forge.functions.FeatureFunctions;
import com.natamus.collective_common_forge.services.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;

public class BiomeSpawnEvent {
    public static boolean onWorldLoad(ServerLevel serverLevel, ServerLevelData serverLevelData) {
        BlockPos spawnPos = null;
        try {
            Registry biomeRegistry = serverLevel.registryAccess().lookupOrThrow(Registries.BIOME);
            Util.loadSpawnBiomeConfig((Registry<Biome>)biomeRegistry);
            if (Util.spawnBiomeListSize() == 0) {
                Constants.logger.info("[Biome Spawn Point] No spawn biome specified in the spawnbiomes.txt config.");
            } else {
                String spawnBiome = Util.getSpawnBiome();
                if (spawnBiome.isBlank()) {
                    Constants.logger.info("[Biome Spawn Point] Received spawn point biome name is empty.");
                } else {
                    Constants.logger.info("[Biome Spawn Point] Finding the nearest '{}' biome. This might take a few seconds.", (Object)spawnBiome);
                    spawnPos = BlockPosFunctions.getCenterNearbyBiome((ServerLevel)serverLevel, (String)spawnBiome);
                    if (spawnPos != null) {
                        Constants.logger.info("[Biome Spawn Point] Biome found!");
                    }
                }
            }
        }
        catch (Exception ex) {
            Constants.logger.info("[Biome Spawn Point] Unable to access Biome Registry on level load.");
        }
        WorldOptions generatorsettings = serverLevel.getServer().getWorldData().worldGenOptions();
        if (Services.MODLOADER.isModLoaded("villagespawnpoint") && generatorsettings.generateStructures()) {
            if (spawnPos == null) {
                spawnPos = new BlockPos(0, 0, 0);
                Constants.logger.info("[Biome Spawn Point] Unable to find biome, but Village Spawn Point installed, finding village near x=0, z=0.");
            } else {
                Constants.logger.info("[Biome Spawn Point] Village Spawn Point installed, finding village near biome. This might take a few seconds.");
            }
            BlockPos villagePos = BlockPosFunctions.getNearbyVillage((ServerLevel)serverLevel, (BlockPos)spawnPos);
            if (villagePos != null) {
                Constants.logger.info("[Biome Spawn Point] Nearby village found.");
                spawnPos = villagePos.immutable();
            }
        }
        if (spawnPos == null) {
            Constants.logger.info("[Biome Spawn Point] Unable to find custom spawn point.");
            return false;
        }
        Constants.logger.info("[Biome Spawn Point] The world will now generate.");
        LevelData.RespawnData previousRespawnData = serverLevel.getRespawnData();
        LevelData.RespawnData newRespawnData = LevelData.RespawnData.of((ResourceKey)previousRespawnData.dimension(), (BlockPos)spawnPos, (float)previousRespawnData.yaw(), (float)previousRespawnData.pitch());
        serverLevel.setRespawnData(newRespawnData);
        if (generatorsettings.generateBonusChest()) {
            FeatureFunctions.placeBonusChest((Level)serverLevel, (BlockPos)spawnPos);
        }
        return true;
    }
}

