/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm;

import com.github.yufiriamazenta.craftorithm.CraftorithmAPI;
import com.github.yufiriamazenta.craftorithm.bstat.Metrics;
import com.github.yufiriamazenta.craftorithm.config.Languages;
import com.github.yufiriamazenta.craftorithm.config.PluginConfigs;
import com.github.yufiriamazenta.craftorithm.crypticlib.BukkitPlugin;
import com.github.yufiriamazenta.craftorithm.crypticlib.CrypticLib;
import com.github.yufiriamazenta.craftorithm.crypticlib.CrypticLibBukkit;
import com.github.yufiriamazenta.craftorithm.crypticlib.MinecraftVersion;
import com.github.yufiriamazenta.craftorithm.crypticlib.chat.BukkitMsgSender;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.AutoTask;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.BukkitLifeCycleTask;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.LifeCycle;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.TaskRule;
import com.github.yufiriamazenta.craftorithm.crypticlib.listener.EventListener;
import com.github.yufiriamazenta.craftorithm.exception.UnsupportedVersionException;
import com.github.yufiriamazenta.craftorithm.hook.listener.OtherPluginsListenerManager;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeManager;
import com.github.yufiriamazenta.craftorithm.util.LangUtils;
import com.github.yufiriamazenta.craftorithm.util.UpdateChecker;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.Plugin;

@AutoTask(rules={@TaskRule(lifeCycle=LifeCycle.ACTIVE, priority=2), @TaskRule(lifeCycle=LifeCycle.RELOAD)})
@EventListener
public final class Craftorithm
extends BukkitPlugin
implements Listener,
BukkitLifeCycleTask {
    private static Craftorithm INSTANCE;

    public Craftorithm() {
        INSTANCE = this;
    }

    @Override
    public void enable() {
        if (MinecraftVersion.current().before(MinecraftVersion.V1_19_4)) {
            BukkitMsgSender.INSTANCE.info("&c[Craftorithm] Unsupported Version");
            throw new UnsupportedVersionException();
        }
        CrypticLib.setDebug((Boolean)PluginConfigs.DEBUG.value());
        this.loadBStat();
        UpdateChecker.pullUpdateCheckRequest((CommandSender)Bukkit.getConsoleSender());
    }

    @Override
    public void disable() {
        RecipeManager.INSTANCE.resetRecipes();
    }

    @EventHandler
    public void onServerLoad(ServerLoadEvent event) {
    }

    private void loadBStat() {
        if (!((Boolean)PluginConfigs.BSTATS.value()).booleanValue()) {
            return;
        }
        Metrics metrics = new Metrics(this, 17821);
        metrics.addCustomChart(new Metrics.SingleLineChart("recipes", () -> RecipeManager.INSTANCE.getRecipeGroups().size()));
    }

    public static Craftorithm instance() {
        return INSTANCE;
    }

    public static CraftorithmAPI api() {
        return CraftorithmAPI.INSTANCE;
    }

    @Override
    public void run(Plugin plugin, LifeCycle lifeCycle) {
        if (lifeCycle == LifeCycle.ACTIVE) {
            CrypticLibBukkit.scheduler().sync(() -> {
                RecipeManager.INSTANCE.reloadRecipeManager();
                OtherPluginsListenerManager.INSTANCE.convertOtherPluginsListeners();
                LangUtils.info(Languages.LOAD_FINISH);
            });
        } else {
            CrypticLib.setDebug((Boolean)PluginConfigs.DEBUG.value());
        }
    }
}

