/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.cmd.sub.item;

import com.github.yufiriamazenta.craftorithm.config.Languages;
import com.github.yufiriamazenta.craftorithm.crypticlib.CrypticLibBukkit;
import com.github.yufiriamazenta.craftorithm.crypticlib.command.BukkitSubcommand;
import com.github.yufiriamazenta.craftorithm.crypticlib.command.CommandInfo;
import com.github.yufiriamazenta.craftorithm.crypticlib.perm.PermInfo;
import com.github.yufiriamazenta.craftorithm.item.impl.CraftorithmItemProvider;
import com.github.yufiriamazenta.craftorithm.util.CollectionsUtils;
import com.github.yufiriamazenta.craftorithm.util.CommandUtils;
import com.github.yufiriamazenta.craftorithm.util.LangUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GiveItemCommand
extends BukkitSubcommand {
    public static final GiveItemCommand INSTANCE = new GiveItemCommand();

    private GiveItemCommand() {
        super(CommandInfo.builder("give").permission(new PermInfo("craftorithm.command.item.give")).usage("&r/craftorithm item give <item_id> [player_name]").build());
    }

    @Override
    public void execute(CommandSender sender, List<String> args) {
        ItemStack itemStack;
        Player player;
        if (args.isEmpty()) {
            this.sendDescriptions(sender);
            return;
        }
        if (args.size() >= 2) {
            player = Bukkit.getPlayer((String)args.get(1));
            if (player == null) {
                LangUtils.sendLang(sender, Languages.COMMAND_ITEM_GIVE_PLAYER_OFFLINE);
                return;
            }
        } else if (CommandUtils.checkSenderIsPlayer(sender)) {
            player = (Player)sender;
        } else {
            return;
        }
        if ((itemStack = CraftorithmItemProvider.INSTANCE.getItem(args.get(0))) == null) {
            LangUtils.sendLang(sender, Languages.COMMAND_ITEM_GIVE_NOT_EXIST_ITEM, CollectionsUtils.newStringHashMap("<item_name>", args.get(0)));
            return;
        }
        HashMap failedItems = player.getInventory().addItem(new ItemStack[]{itemStack});
        if (!failedItems.isEmpty()) {
            if (!CrypticLibBukkit.isFolia()) {
                for (ItemStack stack : failedItems.values()) {
                    player.getWorld().dropItem(player.getLocation(), stack);
                }
            } else {
                Runnable dropTask = () -> {
                    for (ItemStack stack : failedItems.values()) {
                        player.getWorld().dropItem(player.getLocation(), stack);
                    }
                };
                CrypticLibBukkit.scheduler().runOnEntity((Entity)player, dropTask, dropTask);
            }
        }
        LangUtils.sendLang(sender, Languages.COMMAND_ITEM_GIVE_SUCCESS);
    }

    @Override
    public List<String> tab(CommandSender sender, List<String> args) {
        if (args.size() < 2) {
            return new ArrayList<String>(CraftorithmItemProvider.INSTANCE.itemMap().keySet());
        }
        return this.getOnlinePlayerNameList();
    }

    private List<String> getOnlinePlayerNameList() {
        ArrayList<String> onlinePlayerNameList = new ArrayList<String>();
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            onlinePlayerNameList.add(onlinePlayer.getName());
        }
        return onlinePlayerNameList;
    }
}

