/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.cmd.sub.item;

import com.github.yufiriamazenta.craftorithm.config.Languages;
import com.github.yufiriamazenta.craftorithm.crypticlib.command.BukkitSubcommand;
import com.github.yufiriamazenta.craftorithm.crypticlib.command.CommandInfo;
import com.github.yufiriamazenta.craftorithm.crypticlib.perm.PermInfo;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.ItemHelper;
import com.github.yufiriamazenta.craftorithm.item.impl.CraftorithmItemProvider;
import com.github.yufiriamazenta.craftorithm.util.CommandUtils;
import com.github.yufiriamazenta.craftorithm.util.LangUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class SaveItemCommand
extends BukkitSubcommand {
    public static final SaveItemCommand INSTANCE = new SaveItemCommand();

    private SaveItemCommand() {
        super(CommandInfo.builder("save").permission(new PermInfo("craftorithm.command.item.save")).usage("&r/craftorithm item save <file_name> <item_id>").build());
    }

    @Override
    public void execute(CommandSender sender, List<String> args) {
        if (!CommandUtils.checkSenderIsPlayer(sender)) {
            return;
        }
        if (args.size() < 2) {
            this.sendDescriptions(sender);
            return;
        }
        ItemStack item = ((Player)sender).getInventory().getItemInMainHand();
        if (ItemHelper.isAir(item)) {
            LangUtils.sendLang(sender, Languages.COMMAND_ITEM_SAVE_FAILED_SAVE_AIR);
            return;
        }
        CraftorithmItemProvider.INSTANCE.regCraftorithmItem(args.get(0), args.get(1), item.clone());
        LangUtils.sendLang(sender, Languages.COMMAND_ITEM_SAVE_SUCCESS);
    }

    @Override
    public List<String> tab(CommandSender sender, List<String> args) {
        if (args.size() < 2) {
            return new ArrayList<String>(CraftorithmItemProvider.INSTANCE.itemConfigFileMap().keySet());
        }
        return Collections.singletonList("");
    }
}

