/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.cmd.sub.recipe;

import com.github.yufiriamazenta.craftorithm.config.Languages;
import com.github.yufiriamazenta.craftorithm.crypticlib.command.BukkitSubcommand;
import com.github.yufiriamazenta.craftorithm.crypticlib.command.CommandInfo;
import com.github.yufiriamazenta.craftorithm.crypticlib.perm.PermInfo;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeManager;
import com.github.yufiriamazenta.craftorithm.util.LangUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;

public final class DisableRecipeCommand
extends BukkitSubcommand {
    public static final DisableRecipeCommand INSTANCE = new DisableRecipeCommand();

    private DisableRecipeCommand() {
        super(CommandInfo.builder("disable").permission(new PermInfo("craftorithm.command.disable")).usage("&r/craftorithm disable <recipe_id>").build());
    }

    @Override
    public void execute(CommandSender sender, List<String> args) {
        if (args.isEmpty()) {
            this.sendDescriptions(sender);
            return;
        }
        NamespacedKey removeRecipeKey = NamespacedKey.fromString((String)args.get(0));
        if (!RecipeManager.INSTANCE.serverRecipesCache().containsKey(removeRecipeKey)) {
            LangUtils.sendLang(sender, Languages.COMMAND_DISABLE_NOT_EXIST);
            return;
        }
        List<NamespacedKey> removeRecipeKeys = Collections.singletonList(removeRecipeKey);
        if (RecipeManager.INSTANCE.disableOtherPluginsRecipe(removeRecipeKeys, true)) {
            LangUtils.sendLang(sender, Languages.COMMAND_DISABLE_SUCCESS);
        } else {
            LangUtils.sendLang(sender, Languages.COMMAND_DISABLE_FAILED);
        }
    }

    @Override
    public List<String> tab(CommandSender sender, List<String> args) {
        if (args.size() <= 1) {
            ArrayList<String> tabList = new ArrayList<String>();
            for (NamespacedKey key : RecipeManager.INSTANCE.serverRecipesCache().keySet()) {
                String str = key.toString();
                if (!str.contains(args.get(0))) continue;
                tabList.add(key.toString());
            }
            return tabList;
        }
        return List.of("");
    }
}

