/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.cmd.sub.recipe;

import com.github.yufiriamazenta.craftorithm.crypticlib.command.BukkitSubcommand;
import com.github.yufiriamazenta.craftorithm.crypticlib.command.CommandInfo;
import com.github.yufiriamazenta.craftorithm.crypticlib.perm.PermInfo;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.IOHelper;
import com.github.yufiriamazenta.craftorithm.menu.display.RecipeDisplayMenu;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeManager;
import com.github.yufiriamazenta.craftorithm.util.CommandUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Recipe;
import org.jetbrains.annotations.Nullable;

public class DisplayRecipeCommand
extends BukkitSubcommand {
    public static final DisplayRecipeCommand INSTANCE = new DisplayRecipeCommand();

    protected DisplayRecipeCommand() {
        super(CommandInfo.builder("display").permission(new PermInfo("craftorithm.command.display")).usage("&r/craftorithm display <recipe_id>").build());
    }

    @Override
    public void execute(CommandSender sender, List<String> args) {
        Player target;
        if (args.isEmpty()) {
            this.sendDescriptions(sender);
            return;
        }
        if (args.size() >= 2) {
            String targetName = args.get(1);
            Player player = Bukkit.getPlayer((String)targetName);
            if (player == null) {
                IOHelper.info("&cUnknown player: " + targetName);
                return;
            }
            target = player;
        } else {
            if (!CommandUtils.checkSenderIsPlayer(sender)) {
                return;
            }
            target = (Player)sender;
        }
        NamespacedKey namespacedKey = NamespacedKey.fromString((String)args.get(0));
        Recipe recipe = RecipeManager.INSTANCE.getRecipe(namespacedKey);
        if (recipe == null) {
            return;
        }
        new RecipeDisplayMenu(target, recipe, null).openMenu();
    }

    @Override
    @Nullable
    public List<String> tab(CommandSender sender, List<String> args) {
        if (args.size() <= 1) {
            ArrayList<String> tabList = new ArrayList<String>();
            for (NamespacedKey key : RecipeManager.INSTANCE.serverRecipesCache().keySet()) {
                String str = key.toString();
                if (!str.contains(args.get(0))) continue;
                tabList.add(key.toString());
            }
            return tabList;
        }
        if (args.size() == 2) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).toList();
        }
        return Collections.singletonList("");
    }
}

