/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib;

import com.github.yufiriamazenta.craftorithm.crypticlib.CrypticLib;
import com.github.yufiriamazenta.craftorithm.crypticlib.CrypticLibBukkit;
import com.github.yufiriamazenta.craftorithm.crypticlib.chat.BukkitMsgSender;
import com.github.yufiriamazenta.craftorithm.crypticlib.command.BukkitCommand;
import com.github.yufiriamazenta.craftorithm.crypticlib.command.BukkitCommandManager;
import com.github.yufiriamazenta.craftorithm.crypticlib.command.annotation.Command;
import com.github.yufiriamazenta.craftorithm.crypticlib.config.BukkitConfigContainer;
import com.github.yufiriamazenta.craftorithm.crypticlib.config.BukkitConfigWrapper;
import com.github.yufiriamazenta.craftorithm.crypticlib.config.ConfigHandler;
import com.github.yufiriamazenta.craftorithm.crypticlib.internal.PluginScanner;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.AutoTask;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.BukkitLifeCycleTask;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.BukkitLifeCycleTaskWrapper;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.LifeCycle;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.LifeCycleTaskWrapper;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.TaskRule;
import com.github.yufiriamazenta.craftorithm.crypticlib.listener.EventListener;
import com.github.yufiriamazenta.craftorithm.crypticlib.perm.BukkitPermManager;
import com.github.yufiriamazenta.craftorithm.crypticlib.perm.PermInfo;
import com.github.yufiriamazenta.craftorithm.crypticlib.resource.ResourceLoader;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.IOHelper;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.ReflectionHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public abstract class BukkitPlugin
extends JavaPlugin {
    protected final PluginScanner pluginScanner = PluginScanner.INSTANCE;
    protected final Map<String, BukkitConfigContainer> configContainerMap = new ConcurrentHashMap<String, BukkitConfigContainer>();
    protected final String defaultConfigFileName = "config.yml";

    public BukkitPlugin() {
        this.pluginScanner.scanJar(this.getFile());
        ReflectionHelper.setPluginInstance((Object)this);
        CrypticLib.setPluginName(this.getDescription().getName());
        IOHelper.setMsgSender(BukkitMsgSender.INSTANCE);
        this.runLifeCycleTasks(LifeCycle.INIT);
    }

    public final void onLoad() {
        PermInfo.PERM_MANAGER = BukkitPermManager.INSTANCE;
        ResourceLoader.downloadResources(this.getDataFolder());
        this.pluginScanner.getAnnotatedClasses(ConfigHandler.class).forEach(configClass -> {
            ConfigHandler configHandler = configClass.getAnnotation(ConfigHandler.class);
            String path = configHandler.path();
            if (!path.endsWith(".yml") && !path.endsWith(".yaml")) {
                path = path + ".yml";
            }
            BukkitConfigWrapper configWrapper = new BukkitConfigWrapper((Plugin)this, path);
            BukkitConfigContainer configContainer = new BukkitConfigContainer((Class<?>)configClass, configWrapper);
            this.configContainerMap.put(path, configContainer);
            configContainer.reload();
        });
        this.load();
        this.runLifeCycleTasks(LifeCycle.LOAD);
    }

    public final void onEnable() {
        this.pluginScanner.getAnnotatedClasses(EventListener.class).forEach(listenerClass -> {
            try {
                if (!Listener.class.isAssignableFrom((Class<?>)listenerClass)) {
                    return;
                }
                Listener listener = (Listener)ReflectionHelper.getSingletonClassInstance(listenerClass, new Object[0]);
                Bukkit.getPluginManager().registerEvents(listener, (Plugin)this);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                EventListener annotation = listenerClass.getAnnotation(EventListener.class);
                if (!annotation.ignoreClassNotFound()) {
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        });
        this.pluginScanner.getAnnotatedClasses(Command.class).forEach(commandClass -> {
            try {
                if (!BukkitCommand.class.isAssignableFrom((Class<?>)commandClass)) {
                    return;
                }
                BukkitCommand bukkitCommand = (BukkitCommand)ReflectionHelper.getSingletonClassInstance(commandClass, new Object[0]);
                bukkitCommand.register((Plugin)this);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                Command annotation = commandClass.getAnnotation(Command.class);
                if (!annotation.ignoreClassNotFound()) {
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        });
        this.enable();
        this.runLifeCycleTasks(LifeCycle.ENABLE);
        CrypticLibBukkit.scheduler().sync(() -> this.runLifeCycleTasks(LifeCycle.ACTIVE));
    }

    public final void onDisable() {
        this.runLifeCycleTasks(LifeCycle.DISABLE);
        this.configContainerMap.clear();
        BukkitCommandManager.INSTANCE.unregisterAll();
        CrypticLibBukkit.platform().scheduler().cancelTasks();
        this.disable();
    }

    public void load() {
    }

    public void enable() {
    }

    public void disable() {
    }

    public final void reloadPlugin() {
        this.reloadConfig();
        this.runLifeCycleTasks(LifeCycle.RELOAD);
    }

    @NotNull
    public final FileConfiguration getConfig() {
        if (this.configContainerMap.containsKey("config.yml")) {
            return (FileConfiguration)this.configContainerMap.get("config.yml").configWrapper().config();
        }
        throw new UnsupportedOperationException("No default config file");
    }

    public final void saveConfig() {
        this.configContainerMap.forEach((path, configContainer) -> configContainer.configWrapper().saveConfig());
    }

    public final void saveDefaultConfig() {
        BukkitConfigContainer defConfig = new BukkitConfigContainer(((Object)((Object)this)).getClass(), new BukkitConfigWrapper((Plugin)this, "config.yml"));
        defConfig.reload();
        this.configContainerMap.put("config.yml", defConfig);
    }

    public final void reloadConfig() {
        this.configContainerMap.forEach((path, container) -> container.reload());
    }

    private void runLifeCycleTasks(LifeCycle lifeCycle) {
        ArrayList<BukkitLifeCycleTaskWrapper> taskWrappers = new ArrayList<BukkitLifeCycleTaskWrapper>();
        this.pluginScanner.getAnnotatedClasses(AutoTask.class).forEach(taskClass -> {
            try {
                if (!BukkitLifeCycleTask.class.isAssignableFrom((Class<?>)taskClass)) {
                    return;
                }
                AutoTask annotation = taskClass.getAnnotation(AutoTask.class);
                if (annotation == null) {
                    return;
                }
                for (TaskRule taskRule : annotation.rules()) {
                    LifeCycle annotationLifeCycle = taskRule.lifeCycle();
                    int priority = taskRule.priority();
                    if (!annotationLifeCycle.equals((Object)lifeCycle)) continue;
                    BukkitLifeCycleTask task = (BukkitLifeCycleTask)ReflectionHelper.getSingletonClassInstance(taskClass, new Object[0]);
                    BukkitLifeCycleTaskWrapper wrapper = new BukkitLifeCycleTaskWrapper(task, priority);
                    taskWrappers.add(wrapper);
                    return;
                }
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                AutoTask annotation = taskClass.getAnnotation(AutoTask.class);
                if (!annotation.ignoreClassNotFound()) {
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        });
        taskWrappers.sort(Comparator.comparingInt(LifeCycleTaskWrapper::priority));
        for (BukkitLifeCycleTaskWrapper taskWrapper : taskWrappers) {
            taskWrapper.runLifecycleTask(this, lifeCycle);
        }
    }
}

