/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib;

import com.github.yufiriamazenta.craftorithm.crypticlib.platform.BukkitPlatform;
import com.github.yufiriamazenta.craftorithm.crypticlib.platform.FoliaPlatform;
import com.github.yufiriamazenta.craftorithm.crypticlib.platform.IPlatform;
import com.github.yufiriamazenta.craftorithm.crypticlib.platform.PaperPlatform;
import com.github.yufiriamazenta.craftorithm.crypticlib.scheduler.IScheduler;
import org.jetbrains.annotations.NotNull;

public class CrypticLibBukkit {
    private static IPlatform platform;

    @NotNull
    public static IPlatform platform() {
        return platform;
    }

    @NotNull
    public static IScheduler scheduler() {
        return CrypticLibBukkit.platform().scheduler();
    }

    private static void loadPlatform() {
        try {
            Class<?> pluginMetaClass = Class.forName("io.papermc.paper.plugin.configuration.PluginMeta");
            pluginMetaClass.getMethod("isFoliaSupported", new Class[0]);
            platform = FoliaPlatform.INSTANCE;
        }
        catch (ClassNotFoundException e) {
            platform = BukkitPlatform.INSTANCE;
        }
        catch (NoSuchMethodException e) {
            platform = PaperPlatform.INSTANCE;
        }
    }

    public static boolean isFolia() {
        return platform.type().equals((Object)IPlatform.PlatformType.FOLIA);
    }

    public static boolean isPaper() {
        return platform.type().equals((Object)IPlatform.PlatformType.PAPER) || platform.type().equals((Object)IPlatform.PlatformType.FOLIA);
    }

    static {
        CrypticLibBukkit.loadPlatform();
    }
}

