/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.chat;

import com.github.yufiriamazenta.craftorithm.crypticlib.CrypticLib;
import com.github.yufiriamazenta.craftorithm.crypticlib.chat.BukkitTextProcessor;
import com.github.yufiriamazenta.craftorithm.crypticlib.chat.MsgSender;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.StringHelper;
import java.util.Map;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public enum BukkitMsgSender implements MsgSender<CommandSender, BaseComponent, Player>
{
    INSTANCE;


    @Override
    public void sendMsg(CommandSender receiver, String msg, @NotNull Map<String, String> replaceMap) {
        if (receiver == null) {
            return;
        }
        if (msg == null) {
            return;
        }
        msg = StringHelper.replaceStrings(msg, replaceMap);
        if (receiver instanceof Player) {
            msg = BukkitTextProcessor.placeholder((OfflinePlayer)((Player)receiver), msg);
        }
        this.sendMsg(receiver, BukkitTextProcessor.toComponent(BukkitTextProcessor.color(msg)));
    }

    @Override
    public void sendMsg(CommandSender receiver, BaseComponent ... baseComponents) {
        this.sendMsg(receiver, (BaseComponent)new TextComponent(baseComponents));
    }

    @Override
    public void sendMsg(CommandSender receiver, @NotNull BaseComponent baseComponent) {
        if (receiver == null) {
            return;
        }
        receiver.spigot().sendMessage(baseComponent);
    }

    @Override
    public void sendTitle(Player player, String title, String subTitle, int fadeIn, int stay, int fadeOut, Map<String, String> replaceMap) {
        if (player == null) {
            return;
        }
        if (title == null) {
            title = "";
        }
        if (subTitle == null) {
            subTitle = "";
        }
        title = StringHelper.replaceStrings(title, replaceMap);
        subTitle = StringHelper.replaceStrings(subTitle, replaceMap);
        title = BukkitTextProcessor.color(BukkitTextProcessor.placeholder((OfflinePlayer)player, title));
        subTitle = BukkitTextProcessor.color(BukkitTextProcessor.placeholder((OfflinePlayer)player, subTitle));
        player.sendTitle(title, subTitle, fadeIn, stay, fadeOut);
    }

    @Override
    public void sendActionBar(Player player, BaseComponent component) {
        if (player == null) {
            return;
        }
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, component);
    }

    @Override
    public void sendActionBar(Player player, BaseComponent ... baseComponents) {
        this.sendActionBar(player, (BaseComponent)new TextComponent(baseComponents));
    }

    @Override
    public void sendActionBar(Player player, String text, Map<String, String> replaceMap) {
        text = StringHelper.replaceStrings(text, replaceMap);
        text = BukkitTextProcessor.color(BukkitTextProcessor.placeholder((OfflinePlayer)player, text));
        this.sendActionBar(player, BukkitTextProcessor.toComponent(text));
    }

    @Override
    public void broadcast(String msg, Map<String, String> replaceMap) {
        msg = StringHelper.replaceStrings(msg, replaceMap);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.sendMsg(player, msg);
        }
        this.info(msg);
    }

    @Override
    public void broadcastActionbar(String msg, Map<String, String> replaceMap) {
        msg = StringHelper.replaceStrings(msg, replaceMap);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.sendActionBar(player, msg);
        }
    }

    @Override
    public void broadcastTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut, Map<String, String> replaceMap) {
        title = StringHelper.replaceStrings(title, replaceMap);
        subtitle = StringHelper.replaceStrings(subtitle, replaceMap);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.sendTitle(player, title, subtitle, fadeIn, stay, fadeOut);
        }
    }

    @Override
    public void broadcastTitle(String title, String subtitle, Map<String, String> replaceMap) {
        title = StringHelper.replaceStrings(title, replaceMap);
        subtitle = StringHelper.replaceStrings(subtitle, replaceMap);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.sendTitle(player, title, subtitle);
        }
    }

    @Override
    public void info(String msg, Map<String, String> replaceMap) {
        msg = "[" + CrypticLib.pluginName() + "] " + msg;
        this.sendMsg((CommandSender)Bukkit.getConsoleSender(), msg, replaceMap);
    }
}

