/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.chat;

import com.github.yufiriamazenta.craftorithm.crypticlib.MinecraftVersion;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.EntityHelper;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.MaterialHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BukkitTextProcessor {
    private static final Pattern colorPattern = Pattern.compile("&#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})");

    public static String color(String text) {
        if (MinecraftVersion.current().afterOrEquals(MinecraftVersion.V1_16)) {
            StringBuilder strBuilder = new StringBuilder(text);
            Matcher matcher = colorPattern.matcher(strBuilder);
            while (matcher.find()) {
                String colorCode = matcher.group();
                String colorStr = ChatColor.of((String)colorCode.substring(1)).toString();
                strBuilder.replace(matcher.start(), matcher.start() + colorCode.length(), colorStr);
                matcher = colorPattern.matcher(strBuilder);
            }
            text = strBuilder.toString();
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public static String placeholder(OfflinePlayer player, String source) {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            source = PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)source);
        }
        return source;
    }

    public static BaseComponent toComponent(String text) {
        return BukkitTextProcessor.toComponent(text, new ArrayList<BaseComponent>());
    }

    public static BaseComponent toComponent(String text, ClickEvent clickEvent) {
        return BukkitTextProcessor.toComponent(text, (HoverEvent)null, clickEvent);
    }

    public static BaseComponent toComponent(String text, HoverEvent hoverEvent) {
        return BukkitTextProcessor.toComponent(text, hoverEvent, null);
    }

    public static BaseComponent toComponent(String text, HoverEvent hoverEvent, ClickEvent clickEvent) {
        return BukkitTextProcessor.toComponent(text, new ArrayList<BaseComponent>(), hoverEvent, clickEvent);
    }

    public static BaseComponent toComponent(String text, BaseComponent extra) {
        return BukkitTextProcessor.toComponent(text, extra, null, null);
    }

    public static BaseComponent toComponent(String text, BaseComponent extra, ClickEvent clickEvent) {
        return BukkitTextProcessor.toComponent(text, extra, null, clickEvent);
    }

    public static BaseComponent toComponent(String text, BaseComponent extra, HoverEvent hoverEvent) {
        return BukkitTextProcessor.toComponent(text, extra, hoverEvent, null);
    }

    public static BaseComponent toComponent(String text, BaseComponent extra, HoverEvent hoverEvent, ClickEvent clickEvent) {
        return BukkitTextProcessor.toComponent(text, Collections.singletonList(extra), hoverEvent, clickEvent);
    }

    public static BaseComponent toComponent(String text, List<BaseComponent> extra) {
        return BukkitTextProcessor.toComponent(text, extra, null, null);
    }

    public static BaseComponent toComponent(String text, List<BaseComponent> extra, ClickEvent clickEvent) {
        return BukkitTextProcessor.toComponent(text, extra, null, clickEvent);
    }

    public static BaseComponent toComponent(String text, List<BaseComponent> extra, HoverEvent hoverEvent) {
        return BukkitTextProcessor.toComponent(text, extra, hoverEvent, null);
    }

    public static BaseComponent toComponent(String text, List<BaseComponent> extra, HoverEvent hoverEvent, ClickEvent clickEvent) {
        BaseComponent[] baseComponents = TextComponent.fromLegacyText((String)text);
        TextComponent textComponent = new TextComponent(baseComponents);
        textComponent.setHoverEvent(hoverEvent);
        textComponent.setClickEvent(clickEvent);
        if (extra.isEmpty()) {
            return textComponent;
        }
        for (BaseComponent component : extra) {
            textComponent.addExtra(component);
        }
        return textComponent;
    }

    public static TranslatableComponent toTranslatableComponent(@NotNull EntityType entityType) {
        return new TranslatableComponent(EntityHelper.getTranslationKey(entityType), new Object[0]);
    }

    public static TranslatableComponent toTranslatableComponent(@NotNull Entity entity) {
        return BukkitTextProcessor.toTranslatableComponent(entity.getType());
    }

    public static TranslatableComponent toTranslatableComponent(@NotNull Material material) {
        return new TranslatableComponent(MaterialHelper.getTranslationKey(material), new Object[0]);
    }

    public static TranslatableComponent toTranslatableComponent(@NotNull ItemStack itemStack) {
        return new TranslatableComponent(MaterialHelper.getTranslationKey(itemStack.getType()), new Object[0]);
    }

    public static HoverEvent hoverText(String text) {
        return new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(text)});
    }

    public static HoverEvent hoverText(BaseComponent textComponent) {
        return new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{textComponent});
    }

    public static HoverEvent hoverText(Text text) {
        return new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{text});
    }

    public static HoverEvent hoverText(Text ... texts) {
        return new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Content[])texts);
    }

    public static ClickEvent clickOpenUrl(String url) {
        return new ClickEvent(ClickEvent.Action.OPEN_URL, url);
    }

    public static ClickEvent clickOpenFile(String fileUrl) {
        return new ClickEvent(ClickEvent.Action.OPEN_FILE, fileUrl);
    }

    public static ClickEvent clickRunCmd(String command) {
        return new ClickEvent(ClickEvent.Action.RUN_COMMAND, command);
    }

    public static ClickEvent clickSuggestCmd(String command) {
        return new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command);
    }

    public static ClickEvent clickChangePage(String page) {
        return new ClickEvent(ClickEvent.Action.CHANGE_PAGE, page);
    }

    public static ClickEvent clickCopyToClipboard(String text) {
        return new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, text);
    }

    public static BaseComponent setInsertion(BaseComponent baseComponent, String insertion) {
        baseComponent.setInsertion(insertion);
        return baseComponent;
    }

    public static BaseComponent setClickEvent(BaseComponent baseComponent, ClickEvent clickEvent) {
        baseComponent.setClickEvent(clickEvent);
        return baseComponent;
    }

    public static BaseComponent setHoverEvent(BaseComponent baseComponent, HoverEvent hoverEvent) {
        baseComponent.setHoverEvent(hoverEvent);
        return baseComponent;
    }
}

