/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.command;

import com.github.yufiriamazenta.craftorithm.crypticlib.command.CommandHandler;
import com.github.yufiriamazenta.craftorithm.crypticlib.command.CommandInfo;
import com.github.yufiriamazenta.craftorithm.crypticlib.perm.PermInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSubcommand<CommandSender>
implements CommandHandler<CommandSender> {
    protected final Map<String, AbstractSubcommand<CommandSender>> subcommands = new ConcurrentHashMap<String, AbstractSubcommand<CommandSender>>();
    protected final CommandInfo subcommandInfo;

    public AbstractSubcommand(@NotNull CommandInfo subcommandInfo) {
        this.subcommandInfo = subcommandInfo;
    }

    public AbstractSubcommand(@NotNull String name) {
        this(name, null, new ArrayList<String>());
    }

    public AbstractSubcommand(@NotNull String name, @NotNull List<String> aliases) {
        this(name, null, aliases);
    }

    public AbstractSubcommand(@NotNull String name, @Nullable PermInfo permission) {
        this(name, permission, new ArrayList<String>());
    }

    public AbstractSubcommand(@NotNull String name, @Nullable PermInfo permission, @NotNull List<String> aliases) {
        this.subcommandInfo = new CommandInfo(name, permission, aliases);
    }

    @Override
    public final void onCommand(CommandSender sender, List<String> args) {
        CommandHandler.super.onCommand(sender, args);
    }

    @Override
    public final List<String> onTabComplete(CommandSender sender, List<String> args) {
        return CommandHandler.super.onTabComplete(sender, args);
    }

    @NotNull
    public String name() {
        return this.subcommandInfo.name();
    }

    public AbstractSubcommand<CommandSender> setName(String name) {
        this.subcommandInfo.setName(name);
        return this;
    }

    @Nullable
    public PermInfo permission() {
        return this.subcommandInfo.permission();
    }

    public AbstractSubcommand<CommandSender> setPermission(@NotNull String permission) {
        this.subcommandInfo.setPermission(new PermInfo(permission));
        return this;
    }

    public AbstractSubcommand<CommandSender> setPermission(@Nullable PermInfo permission) {
        this.subcommandInfo.setPermission(permission);
        return this;
    }

    @NotNull
    public List<String> aliases() {
        return this.subcommandInfo.aliases();
    }

    public AbstractSubcommand<CommandSender> setAliases(@NotNull List<String> aliases) {
        this.subcommandInfo.setAliases(aliases);
        return this;
    }

    public AbstractSubcommand<CommandSender> addAliases(@NotNull String alias) {
        this.subcommandInfo.aliases().add(alias);
        return this;
    }

    @Override
    @NotNull
    public Map<String, AbstractSubcommand<CommandSender>> subcommands() {
        return this.subcommands;
    }

    @Override
    public AbstractSubcommand<CommandSender> regSub(@NotNull AbstractSubcommand<CommandSender> subcommandHandler) {
        return (AbstractSubcommand)CommandHandler.super.regSub(subcommandHandler);
    }

    @Override
    public void registerPerms() {
        CommandHandler.super.registerPerms();
        PermInfo permission = this.permission();
        if (permission != null) {
            permission.register();
        }
    }

    @Override
    public CommandInfo commandInfo() {
        return this.subcommandInfo;
    }
}

