/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.command;

import com.github.yufiriamazenta.craftorithm.crypticlib.command.CommandInfo;
import com.github.yufiriamazenta.craftorithm.crypticlib.command.CommandManager;
import com.github.yufiriamazenta.craftorithm.crypticlib.perm.PermInfo;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.ReflectionHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public enum BukkitCommandManager implements CommandManager<Plugin, TabExecutor, PluginCommand>
{
    INSTANCE;

    private final CommandMap serverCommandMap;
    private final Map<String, Command> serverCommandMapKnownCommands;
    private final Constructor<?> pluginCommandConstructor;
    private final Map<String, PluginCommand> registeredCommands = new ConcurrentHashMap<String, PluginCommand>();
    private final Method serverSyncCommandsMethod;

    private BukkitCommandManager() {
        Method getCommandMapMethod = ReflectionHelper.getMethod(Bukkit.getServer().getClass(), "getCommandMap", new Class[0]);
        this.serverCommandMap = (CommandMap)ReflectionHelper.invokeMethod(getCommandMapMethod, Bukkit.getServer(), new Object[0]);
        Field knownCommandsField = ReflectionHelper.getDeclaredField(SimpleCommandMap.class, "knownCommands");
        this.serverCommandMapKnownCommands = (Map)ReflectionHelper.getDeclaredFieldObj(knownCommandsField, this.serverCommandMap);
        this.pluginCommandConstructor = ReflectionHelper.getDeclaredConstructor(PluginCommand.class, String.class, Plugin.class);
        this.serverSyncCommandsMethod = ReflectionHelper.getMethod(Bukkit.getServer().getClass(), "syncCommands", new Class[0]);
    }

    @Override
    public PluginCommand register(@NotNull Plugin plugin, @NotNull CommandInfo commandInfo, @NotNull TabExecutor commandExecutor) {
        String usage;
        PluginCommand pluginCommand = (PluginCommand)ReflectionHelper.invokeDeclaredConstructor(this.pluginCommandConstructor, commandInfo.name(), plugin);
        pluginCommand.setAliases(commandInfo.aliases());
        String description = commandInfo.description();
        pluginCommand.setDescription(description == null ? "" : description);
        PermInfo permInfo = commandInfo.permission();
        if (permInfo != null) {
            pluginCommand.setPermission(permInfo.permission());
        }
        pluginCommand.setUsage((usage = commandInfo.usage()) == null ? "" : usage);
        pluginCommand.setExecutor((CommandExecutor)commandExecutor);
        pluginCommand.setTabCompleter((TabCompleter)commandExecutor);
        this.serverCommandMap.register(plugin.getName(), (Command)pluginCommand);
        this.registeredCommands.put(commandInfo.name(), pluginCommand);
        return pluginCommand;
    }

    @Override
    public PluginCommand unregister(String commandName) {
        PluginCommand command = this.registeredCommands.get(commandName);
        if (command == null) {
            return null;
        }
        command.unregister(this.serverCommandMap);
        this.serverCommandMapKnownCommands.remove(commandName);
        for (String alias : command.getAliases()) {
            this.serverCommandMapKnownCommands.remove(alias);
        }
        String commandNamespace = command.getPlugin().getName().toLowerCase(Locale.ENGLISH);
        this.serverCommandMapKnownCommands.remove(commandNamespace + ":" + commandName.toLowerCase(Locale.ENGLISH));
        for (String alias : command.getAliases()) {
            this.serverCommandMapKnownCommands.remove(commandNamespace + ":" + alias);
        }
        this.registeredCommands.remove(commandName);
        return command;
    }

    @Override
    public void unregisterAll() {
        this.registeredCommands.forEach((pluginName, command) -> command.unregister(this.serverCommandMap));
        this.registeredCommands.clear();
    }

    @Override
    public Map<String, PluginCommand> registeredCommands() {
        return this.registeredCommands;
    }

    public void syncCommands() {
        ReflectionHelper.invokeMethod(this.serverSyncCommandsMethod, Bukkit.getServer(), new Object[0]);
    }
}

