/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.command;

import com.github.yufiriamazenta.craftorithm.crypticlib.command.AbstractSubcommand;
import com.github.yufiriamazenta.craftorithm.crypticlib.command.CommandInfo;
import com.github.yufiriamazenta.craftorithm.crypticlib.command.annotation.Subcommand;
import com.github.yufiriamazenta.craftorithm.crypticlib.perm.PermInfo;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CommandHandler<CommandSender> {
    default public void execute(@NotNull CommandSender sender, @NotNull List<String> args) {
        this.sendDescriptions(sender);
    }

    @Nullable
    default public List<String> tab(@NotNull CommandSender sender, @NotNull List<String> args) {
        return null;
    }

    @NotNull
    default public Map<String, AbstractSubcommand<CommandSender>> subcommands() {
        return new HashMap<String, AbstractSubcommand<CommandSender>>();
    }

    default public CommandHandler<?> regSub(@NotNull AbstractSubcommand<CommandSender> subcommandHandler) {
        this.subcommands().put(subcommandHandler.name(), subcommandHandler);
        for (String alias : subcommandHandler.aliases()) {
            this.subcommands().put(alias, subcommandHandler);
        }
        return this;
    }

    default public void onCommand(CommandSender sender, List<String> args) {
        PermInfo perm;
        if (args.isEmpty() || this.subcommands().isEmpty() || !this.subcommands().containsKey(args.get(0))) {
            this.execute(sender, args);
            return;
        }
        AbstractSubcommand<CommandSender> subcommand = this.subcommands().get(args.get(0));
        if (subcommand != null && ((perm = subcommand.permission()) == null || perm.hasPermission(sender))) {
            subcommand.onCommand(sender, args.subList(1, args.size()));
        }
    }

    default public List<String> onTabComplete(CommandSender sender, List<String> args) {
        List<String> tab = this.tab(sender, args);
        ArrayList<Object> arguments = tab == null ? new ArrayList() : new ArrayList<String>(tab);
        if (!this.subcommands().isEmpty()) {
            if (args.size() > 1) {
                AbstractSubcommand<CommandSender> subcommand = this.subcommands().get(args.get(0));
                if (subcommand != null) {
                    PermInfo perm = subcommand.permission();
                    if (perm != null) {
                        if (perm.hasPermission(sender)) {
                            return subcommand.onTabComplete(sender, args.subList(1, args.size()));
                        }
                        return Collections.singletonList("");
                    }
                    return subcommand.onTabComplete(sender, args.subList(1, args.size()));
                }
                return Collections.singletonList("");
            }
            for (String arg : this.subcommands().keySet()) {
                AbstractSubcommand<CommandSender> subcommand = this.subcommands().get(arg);
                PermInfo perm = subcommand.permission();
                if (perm != null) {
                    if (!perm.hasPermission(sender)) continue;
                    arguments.add(arg);
                    continue;
                }
                arguments.add(arg);
            }
        }
        if (!args.isEmpty()) {
            arguments.removeIf(str -> !str.contains((CharSequence)args.get(args.size() - 1)));
        }
        if (arguments.isEmpty()) {
            return Collections.singletonList("");
        }
        return arguments;
    }

    default public void registerPerms() {
        for (AbstractSubcommand<CommandSender> commandTreeNode : this.subcommands().values()) {
            commandTreeNode.registerPerms();
        }
    }

    default public void scanSubCommands() {
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Subcommand.class) || !AbstractSubcommand.class.isAssignableFrom(field.getType())) continue;
            AbstractSubcommand subcommand = (AbstractSubcommand)ReflectionHelper.getDeclaredFieldObj(field, this);
            this.regSub(subcommand);
        }
        for (AbstractSubcommand abstractSubcommand : this.subcommands().values()) {
            abstractSubcommand.scanSubCommands();
        }
    }

    default public List<String> toDescriptions(CommandSender commandSender) {
        String desc;
        ArrayList<String> description = new ArrayList<String>();
        StringJoiner nameJoiner = new StringJoiner(" | ", "&7", ":");
        nameJoiner.add(this.commandInfo().name());
        for (String alias : this.commandInfo().aliases()) {
            nameJoiner.add(alias);
        }
        description.add(nameJoiner.toString());
        String usage = this.commandInfo().usage();
        if (usage != null && !usage.isEmpty()) {
            description.add(usage);
        }
        if ((desc = this.commandInfo().description()) != null && !desc.isEmpty()) {
            description.add(desc);
        }
        this.subcommands().forEach((key, subcommand) -> {
            String subDesc;
            PermInfo permission = subcommand.permission();
            if (permission != null && !PermInfo.PERM_MANAGER.hasPermission(commandSender, permission.permission())) {
                return;
            }
            StringJoiner subNameJoiner = new StringJoiner(" | ", " &7- ", "");
            subNameJoiner.add(subcommand.commandInfo().name());
            for (String alias : subcommand.commandInfo().aliases()) {
                subNameJoiner.add(alias);
            }
            description.add(subNameJoiner.toString());
            String subUsage = subcommand.commandInfo().usage();
            if (subUsage != null && !subUsage.isEmpty()) {
                description.add("   " + subUsage);
            }
            if ((subDesc = subcommand.commandInfo().description()) == null || subDesc.isEmpty()) {
                return;
            }
            description.add("   " + subDesc);
        });
        return description;
    }

    public void sendDescriptions(CommandSender var1);

    public CommandInfo commandInfo();
}

