/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.config;

import com.github.yufiriamazenta.craftorithm.crypticlib.MinecraftVersion;
import com.github.yufiriamazenta.craftorithm.crypticlib.config.ConfigWrapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitConfigWrapper
extends ConfigWrapper<YamlConfiguration> {
    public BukkitConfigWrapper(@NotNull Plugin plugin, @NotNull String path) {
        super(plugin.getDataFolder(), path);
    }

    public BukkitConfigWrapper(@NotNull File file) {
        super(file);
    }

    @Override
    public boolean contains(String key) {
        return ((YamlConfiguration)this.config()).contains(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(@NotNull String key, @Nullable Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            ((YamlConfiguration)this.config()).set(key, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setComments(@NotNull String key, @Nullable List<String> comments) {
        Object object = this.lock;
        synchronized (object) {
            if (MinecraftVersion.current().before(MinecraftVersion.V1_18_1)) {
                return;
            }
            ((YamlConfiguration)this.config()).setComments(key, comments);
        }
    }

    @Override
    @Nullable
    public List<String> getComments(@NotNull String key) {
        if (MinecraftVersion.current().afterOrEquals(MinecraftVersion.V1_18_1)) {
            return ((YamlConfiguration)this.config()).getComments(key);
        }
        return new ArrayList<String>();
    }

    @Override
    public void reloadConfig() {
        this.saveDefaultConfigFile();
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveConfig() {
        Object object = this.lock;
        synchronized (object) {
            try {
                ((YamlConfiguration)this.config()).save(this.configFile);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

