/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.config;

import com.github.yufiriamazenta.craftorithm.crypticlib.util.IOHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigWrapper<C> {
    protected final File configFile;
    protected final String path;
    protected C config;
    protected final Object lock = new Object();

    public ConfigWrapper(@NotNull File dataFolder, @NotNull String path) {
        this.path = path;
        this.configFile = new File(dataFolder, path);
    }

    public ConfigWrapper(@NotNull File file) {
        this.configFile = file;
        this.path = file.getPath();
    }

    @NotNull
    public C config() {
        if (this.config == null) {
            this.reloadConfig();
        }
        return this.config;
    }

    public abstract boolean contains(String var1);

    public abstract void set(@NotNull String var1, @Nullable Object var2);

    public abstract void setComments(@NotNull String var1, @Nullable List<String> var2);

    @Nullable
    public abstract List<String> getComments(@NotNull String var1);

    public abstract void reloadConfig();

    public abstract void saveConfig();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDefaultConfigFile() {
        ConfigWrapper configWrapper = this;
        synchronized (configWrapper) {
            if (!this.configFile.exists()) {
                try {
                    File folder = this.configFile.getParentFile();
                    if (!folder.exists()) {
                        folder.mkdirs();
                    }
                    if (!this.configFile.exists()) {
                        int read;
                        FileOutputStream output = new FileOutputStream(this.configFile);
                        InputStream input = this.getResource(this.path);
                        if (input == null) {
                            throw new NullPointerException();
                        }
                        Objects.requireNonNull(output, "out");
                        byte[] buffer = new byte[8192];
                        while ((read = input.read(buffer, 0, 8192)) >= 0) {
                            output.write(buffer, 0, read);
                        }
                        output.close();
                        input.close();
                    }
                }
                catch (IOException | IllegalArgumentException | NullPointerException e) {
                    IOHelper.createNewFile(this.configFile);
                }
            }
        }
    }

    @NotNull
    public String filePath() {
        return this.path;
    }

    @NotNull
    public File configFile() {
        return this.configFile;
    }

    @Nullable
    protected InputStream getResource(@NotNull String filename) {
        try {
            URL url = this.getClass().getClassLoader().getResource(filename);
            if (url == null) {
                return null;
            }
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException var4) {
            return null;
        }
    }
}

