/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.config.node;

import com.github.yufiriamazenta.craftorithm.crypticlib.MinecraftVersion;
import com.github.yufiriamazenta.craftorithm.crypticlib.config.ConfigWrapper;
import com.github.yufiriamazenta.craftorithm.crypticlib.config.node.ConfigNode;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public abstract class BukkitConfigNode<T>
extends ConfigNode<T, ConfigurationSection> {
    public BukkitConfigNode(@NotNull String key, @NotNull T def) {
        super(key, def);
    }

    public BukkitConfigNode(@NotNull String key, @NotNull T def, @NotNull List<String> defComments) {
        super(key, def, defComments);
    }

    public BukkitConfigNode(String key, T def, @NotNull String defComment) {
        super(key, def, defComment);
    }

    @Override
    public void saveDef(@NotNull ConfigurationSection config) {
        if (!config.contains(this.key)) {
            this.setValue(this.def);
        }
        if (MinecraftVersion.current().afterOrEquals(MinecraftVersion.V1_18_1)) {
            if (this.defComments == null) {
                return;
            }
            if (!config.getComments(this.key).isEmpty()) {
                return;
            }
            this.setComments(this.defComments);
        }
    }

    protected List<String> getCommentsFromConfig() {
        return ((ConfigWrapper)this.configContainer.configWrapper()).getComments(this.key);
    }
}

