/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.config.node;

import com.github.yufiriamazenta.craftorithm.crypticlib.config.ConfigContainer;
import com.github.yufiriamazenta.craftorithm.crypticlib.config.ConfigWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigNode<T, C> {
    protected final String key;
    protected final T def;
    protected final List<String> defComments;
    protected T value;
    protected List<String> comments;
    protected ConfigContainer<?> configContainer;

    public ConfigNode(String key, T def) {
        this(key, def, new ArrayList<String>());
    }

    public ConfigNode(String key, T def, @NotNull String defComment) {
        this(key, def, new ArrayList<String>(Collections.singletonList(defComment)));
    }

    public ConfigNode(@NotNull String key, @NotNull T def, @NotNull List<String> defComments) {
        this.key = key;
        this.def = def;
        this.defComments = defComments;
    }

    @NotNull
    public T value() {
        return this.value;
    }

    public void setValue(@NotNull T value) {
        this.value = value;
        ((ConfigWrapper)this.configContainer.configWrapper()).set(this.key, value);
    }

    @NotNull
    public T def() {
        return this.def;
    }

    public List<String> getDefComments() {
        return this.defComments;
    }

    @NotNull
    public String key() {
        return this.key;
    }

    public ConfigContainer<?> configContainer() {
        return this.configContainer;
    }

    public ConfigNode<T, C> setConfigContainer(ConfigContainer<?> configContainer) {
        this.configContainer = configContainer;
        return this;
    }

    public void saveConfig() {
        ((ConfigWrapper)this.configContainer.configWrapper()).saveConfig();
    }

    public void setComments(@Nullable List<String> comments) {
        this.comments = comments;
        ((ConfigWrapper)this.configContainer.configWrapper()).setComments(this.key, comments);
    }

    public void setComment(@Nullable String comment) {
        this.setComments(Collections.singletonList(comment));
    }

    @Nullable
    public List<String> getComments() {
        return this.comments;
    }

    public abstract void load(@NotNull C var1);

    public abstract void saveDef(@NotNull C var1);
}

