/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.config.node.impl.bukkit;

import com.github.yufiriamazenta.craftorithm.crypticlib.config.node.BukkitConfigNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public class ConfigSectionConfig
extends BukkitConfigNode<ConfigurationSection> {
    private final Map<String, Object> default_;

    public ConfigSectionConfig(@NotNull String key) {
        this(key, (List<String>)new ArrayList<String>());
    }

    public ConfigSectionConfig(@NotNull String key, @NotNull String defComment) {
        this(key, (List<String>)new ArrayList<String>(Collections.singletonList(defComment)));
    }

    public ConfigSectionConfig(@NotNull String key, @NotNull List<String> defComments) {
        this(key, null, defComments);
    }

    public ConfigSectionConfig(@NotNull String key, Map<String, Object> default_) {
        this(key, default_, (List<String>)new ArrayList<String>());
    }

    public ConfigSectionConfig(String key, Map<String, Object> default_, @NotNull String defComment) {
        super(key, null, defComment);
        this.default_ = default_;
    }

    public ConfigSectionConfig(@NotNull String key, Map<String, Object> default_, @NotNull List<String> defComments) {
        super(key, null, defComments);
        this.default_ = default_;
    }

    @Override
    public void load(@NotNull ConfigurationSection config) {
        this.setValue(Objects.requireNonNull(config.getConfigurationSection(this.key)));
        this.setComments(this.getCommentsFromConfig());
    }

    @Override
    public void saveDef(@NotNull ConfigurationSection config) {
        if (!config.contains(this.key)) {
            if (this.default_ != null) {
                config.createSection(this.key, this.default_);
            } else {
                config.createSection(this.key);
            }
        }
    }
}

