/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.conversation;

import com.github.yufiriamazenta.craftorithm.crypticlib.CrypticLibBukkit;
import com.github.yufiriamazenta.craftorithm.crypticlib.chat.BukkitMsgSender;
import com.github.yufiriamazenta.craftorithm.crypticlib.conversation.Prompt;
import com.github.yufiriamazenta.craftorithm.crypticlib.conversation.handler.ConversationHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class Conversation {
    private final Player who;
    private final Plugin plugin;
    private Prompt prompt;
    private String cancelInput;
    private final Map<Object, Object> data;
    private Consumer<Map<Object, Object>> endTask;

    public Conversation(@NotNull Plugin plugin, @NotNull Player who, @NotNull Prompt firstPrompt) {
        this.plugin = plugin;
        this.who = who;
        this.prompt = firstPrompt;
        this.data = new ConcurrentHashMap<Object, Object>();
        this.cancelInput = "cancel";
        this.endTask = null;
    }

    public Conversation(@NotNull Plugin plugin, @NotNull Player who, @NotNull Prompt firstPrompt, Consumer<Map<Object, Object>> endTask) {
        this.plugin = plugin;
        this.who = who;
        this.prompt = firstPrompt;
        this.data = new ConcurrentHashMap<Object, Object>();
        this.cancelInput = "cancel";
        this.endTask = endTask;
    }

    public Conversation(@NotNull Plugin plugin, @NotNull Player who, @NotNull Prompt firstPrompt, @NotNull String cancelInput) {
        this.plugin = plugin;
        this.who = who;
        this.prompt = firstPrompt;
        this.data = new ConcurrentHashMap<Object, Object>();
        this.cancelInput = cancelInput;
        this.endTask = null;
    }

    public Conversation(@NotNull Plugin plugin, @NotNull Player who, @NotNull Prompt firstPrompt, @NotNull String cancelInput, Consumer<Map<Object, Object>> endTask) {
        this.plugin = plugin;
        this.who = who;
        this.prompt = firstPrompt;
        this.data = new ConcurrentHashMap<Object, Object>();
        this.cancelInput = cancelInput;
        this.endTask = endTask;
    }

    public Conversation(@NotNull Plugin plugin, @NotNull Player who, Prompt firstPrompt, Map<Object, Object> data, String cancelInput) {
        this.plugin = plugin;
        this.who = who;
        this.prompt = firstPrompt;
        this.data = data;
        this.cancelInput = cancelInput;
        this.endTask = null;
    }

    public Conversation(@NotNull Plugin plugin, @NotNull Player who, Prompt firstPrompt, Map<Object, Object> data, String cancelInput, Consumer<Map<Object, Object>> endTask) {
        this.plugin = plugin;
        this.who = who;
        this.prompt = firstPrompt;
        this.data = data;
        this.cancelInput = cancelInput;
        this.endTask = endTask;
    }

    public void start() {
        ConversationHandler.INSTANCE.startChat(this.who, this);
        BukkitMsgSender.INSTANCE.sendMsg((CommandSender)this.who, this.prompt.promptText(this.data));
    }

    public void end() {
        ConversationHandler.INSTANCE.endChat(this.who);
        if (this.endTask != null) {
            this.endTask.accept(this.data);
        }
    }

    public void handleInput(String input) {
        CrypticLibBukkit.platform().scheduler().sync(() -> {
            if (input.equalsIgnoreCase(this.cancelInput)) {
                this.end();
                return;
            }
            this.prompt = this.prompt.acceptInput(this.data, input);
            if (this.prompt == null) {
                this.end();
                return;
            }
            BukkitMsgSender.INSTANCE.sendMsg((CommandSender)this.who, this.prompt.promptText(this.data));
        });
    }

    public Consumer<Map<Object, Object>> endTask() {
        return this.endTask;
    }

    public Conversation setEndTask(Consumer<Map<Object, Object>> endTask) {
        this.endTask = endTask;
        return this;
    }

    public String cancelInput() {
        return this.cancelInput;
    }

    public Conversation setCancelInput(String cancelInput) {
        this.cancelInput = cancelInput;
        return this;
    }

    public Plugin plugin() {
        return this.plugin;
    }

    public Map<Object, Object> data() {
        return this.data;
    }

    public Player who() {
        return this.who;
    }
}

