/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.crypticlib.conversation.handler;

import com.github.yufiriamazenta.craftorithm.crypticlib.conversation.Conversation;
import com.github.yufiriamazenta.craftorithm.crypticlib.listener.EventListener;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;

@EventListener
public enum ConversationHandler implements Listener
{
    INSTANCE;

    private final Map<UUID, Conversation> conversationMap = new ConcurrentHashMap<UUID, Conversation>();

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChat(AsyncPlayerChatEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        if (!this.conversationMap.containsKey(uuid)) {
            return;
        }
        event.setCancelled(true);
        this.conversationMap.get(uuid).handleInput(event.getMessage());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.endChat(event.getPlayer());
    }

    public void startChat(Player player, Conversation conversation) {
        this.conversationMap.put(player.getUniqueId(), conversation);
    }

    public void endChat(Player player) {
        this.conversationMap.remove(player.getUniqueId());
    }
}

